/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Objects;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMappingValueStatus;

public class FactMappingValue {
    private FactIdentifier factIdentifier;
    private ExpressionIdentifier expressionIdentifier;
    private Object rawValue;
    @XStreamOmitField
    private FactMappingValueStatus status = FactMappingValueStatus.SUCCESS;
    @XStreamOmitField
    private Object errorValue;
    @XStreamOmitField
    private String exceptionMessage;

    public FactMappingValue() {
    }

    public FactMappingValue(FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier, Object rawValue) {
        this.factIdentifier = Objects.requireNonNull(factIdentifier, "FactIdentifier has to be not null");
        this.expressionIdentifier = Objects.requireNonNull(expressionIdentifier, "ExpressionIdentifier has to be not null");
        this.rawValue = rawValue;
    }

    public void setRawValue(Object rawValue) {
        this.rawValue = rawValue;
    }

    public FactIdentifier getFactIdentifier() {
        return this.factIdentifier;
    }

    public ExpressionIdentifier getExpressionIdentifier() {
        return this.expressionIdentifier;
    }

    public Object getRawValue() {
        return this.rawValue;
    }

    FactMappingValue cloneFactMappingValue() {
        FactMappingValue cloned = new FactMappingValue();
        cloned.expressionIdentifier = this.expressionIdentifier;
        cloned.factIdentifier = this.factIdentifier;
        cloned.rawValue = this.rawValue;
        return cloned;
    }

    public FactMappingValueStatus getStatus() {
        return this.status;
    }

    public Object getErrorValue() {
        return this.errorValue;
    }

    public void setErrorValue(Object errorValue) {
        this.errorValue = errorValue;
        this.status = FactMappingValueStatus.FAILED_WITH_ERROR;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
        this.status = FactMappingValueStatus.FAILED_WITH_EXCEPTION;
    }

    public void resetStatus() {
        this.status = FactMappingValueStatus.SUCCESS;
        this.exceptionMessage = null;
        this.errorValue = null;
    }
}

