/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import java.util.HashMap;
import java.util.Map;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;

public class SimulationRunMetadata {
    protected int available;
    protected int executed;
    protected double coveragePercentage;
    protected Map<String, Integer> outputCounter = new HashMap<String, Integer>();
    protected Map<ScenarioWithIndex, Map<String, Integer>> scenarioCounter = new HashMap<ScenarioWithIndex, Map<String, Integer>>();

    public SimulationRunMetadata() {
    }

    public SimulationRunMetadata(int available, int executed, Map<String, Integer> outputCounter, Map<ScenarioWithIndex, Map<String, Integer>> scenarioCounter) {
        this.available = available;
        this.executed = executed;
        this.outputCounter.putAll(outputCounter);
        this.scenarioCounter.putAll(scenarioCounter);
        this.coveragePercentage = (double)executed / (double)available;
    }

    public int getAvailable() {
        return this.available;
    }

    public int getExecuted() {
        return this.executed;
    }

    public double getCoveragePercentage() {
        return (double)this.executed / (double)this.available * 100.0;
    }

    public Map<String, Integer> getOutputCounter() {
        return this.outputCounter;
    }

    public Map<ScenarioWithIndex, Map<String, Integer>> getScenarioCounter() {
        return this.scenarioCounter;
    }
}

