/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.impl;

import java.util.function.Function;
import org.drools.ruleunits.api.conf.RuleUnitConfig;
import org.drools.ruleunits.impl.AbstractRuleUnitDescription;
import org.drools.ruleunits.impl.SimpleRuleUnitVariable;
import org.drools.ruleunits.impl.UndefinedGeneratedRuleUnitVariableException;
import org.drools.ruleunits.impl.UndefinedRuleUnitVariableException;
import org.drools.util.TypeResolver;
import org.kie.internal.ruleunit.RuleUnitVariable;

public class GeneratedRuleUnitDescription
extends AbstractRuleUnitDescription {
    private final Function<String, Class<?>> typeResolver;
    private final String name;
    private final String packageName;
    private final String simpleName;
    private final String canonicalName;

    public GeneratedRuleUnitDescription(String name, Function<String, Class<?>> typeResolver) {
        this.typeResolver = typeResolver;
        this.name = name;
        int width = name.lastIndexOf(46);
        if (width > -1) {
            this.simpleName = name.substring(width + 1);
            this.packageName = name.substring(0, width);
            this.canonicalName = this.packageName + "." + this.simpleName;
        } else {
            this.simpleName = name;
            this.packageName = "";
            this.canonicalName = this.simpleName;
        }
        this.setConfig(RuleUnitConfig.DEFAULT);
    }

    public GeneratedRuleUnitDescription(String name, TypeResolver typeResolver) {
        this(name, (String fqcn) -> GeneratedRuleUnitDescription.uncheckedLoadClass(typeResolver, fqcn));
    }

    public GeneratedRuleUnitDescription(String name, ClassLoader contextClassLoader) {
        this(name, (String fqcn) -> GeneratedRuleUnitDescription.uncheckedLoadClass(contextClassLoader, fqcn));
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getRuleUnitName() {
        return this.name;
    }

    @Override
    public RuleUnitVariable getVar(String name) {
        try {
            return super.getVar(name);
        }
        catch (UndefinedRuleUnitVariableException e) {
            throw new UndefinedGeneratedRuleUnitVariableException(e.getVariable(), e.getUnit());
        }
    }

    public void putSimpleVar(String name, String varTypeFQCN) {
        Class<?> varType = this.typeResolver.apply(varTypeFQCN);
        this.putSimpleVar(name, varType);
    }

    public void putDatasourceVar(String name, String datasourceTypeFQCN, String datasourceParameterTypeFQCN) {
        this.putDatasourceVar(name, this.typeResolver.apply(datasourceTypeFQCN), this.typeResolver.apply(datasourceParameterTypeFQCN));
    }

    public void putSimpleVar(String name, Class<?> varType) {
        this.putRuleUnitVariable(new SimpleRuleUnitVariable(name, varType));
    }

    public void putDatasourceVar(String name, Class<?> datasourceType, Class<?> datasourceParameterType) {
        this.putRuleUnitVariable(new SimpleRuleUnitVariable(name, datasourceType, datasourceParameterType, true));
    }

    private static Class<?> uncheckedLoadClass(TypeResolver typeResolver, String fqcn) {
        try {
            return typeResolver.resolveType(fqcn);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static Class<?> uncheckedLoadClass(ClassLoader classLoader, String fqcn) {
        try {
            return classLoader.loadClass(fqcn);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

