/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.impl;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.drools.ruleunits.api.conf.ClockType;
import org.drools.ruleunits.api.conf.EventProcessingType;
import org.drools.ruleunits.api.conf.RuleUnitConfig;
import org.drools.ruleunits.impl.UndefinedRuleUnitVariableException;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.internal.ruleunit.RuleUnitDescription;
import org.kie.internal.ruleunit.RuleUnitVariable;

public abstract class AbstractRuleUnitDescription
implements RuleUnitDescription {
    private final Map<String, RuleUnitVariable> varDeclarations = new HashMap<String, RuleUnitVariable>();
    private RuleUnitConfig config;

    public Optional<Class<?>> getDatasourceType(String name) {
        return Optional.ofNullable(this.varDeclarations.get(name)).filter(RuleUnitVariable::isDataSource).map(RuleUnitVariable::getDataSourceParameterType);
    }

    public Optional<Type> getVarType(String name) {
        return Optional.ofNullable(this.varDeclarations.get(name)).map(RuleUnitVariable::getType);
    }

    public boolean hasVar(String name) {
        return this.varDeclarations.containsKey(name);
    }

    public RuleUnitVariable getVar(String name) {
        RuleUnitVariable ruleUnitVariable = this.varDeclarations.get(name);
        if (ruleUnitVariable == null) {
            throw new UndefinedRuleUnitVariableException(name, this.getCanonicalName());
        }
        return ruleUnitVariable;
    }

    public Collection<String> getUnitVars() {
        return this.varDeclarations.keySet();
    }

    public Collection<RuleUnitVariable> getUnitVarDeclarations() {
        return this.varDeclarations.values();
    }

    public boolean hasDataSource(String name) {
        RuleUnitVariable ruleUnitVariable = this.varDeclarations.get(name);
        return ruleUnitVariable != null && ruleUnitVariable.isDataSource();
    }

    protected void putRuleUnitVariable(RuleUnitVariable varDeclaration) {
        this.varDeclarations.put(varDeclaration.getName(), varDeclaration);
    }

    protected void setConfig(RuleUnitConfig config) {
        this.config = config;
    }

    public RuleUnitConfig getConfig() {
        return this.config;
    }

    public ClockTypeOption getClockType() {
        return this.config.getDefaultedClockType() == ClockType.PSEUDO ? ClockTypeOption.PSEUDO : ClockTypeOption.REALTIME;
    }

    public Collection<KieBaseOption> getKieBaseOptions() {
        ArrayList<KieBaseOption> kieBaseOptions = new ArrayList<KieBaseOption>();
        EventProcessingOption eventProcessingOption = this.config.getDefaultedEventProcessingType() == EventProcessingType.CLOUD ? EventProcessingOption.CLOUD : EventProcessingOption.STREAM;
        kieBaseOptions.add((KieBaseOption)eventProcessingOption);
        return kieBaseOptions;
    }

    public boolean equals(Object obj) {
        return obj instanceof RuleUnitDescription && this.getRuleUnitName().equals(((RuleUnitDescription)obj).getRuleUnitName());
    }

    public int hashCode() {
        return this.getRuleUnitName().hashCode();
    }
}

