/*
 * Copyright 2020 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.drools.ruleunits.impl.factory;

import java.io.Serializable;

import org.drools.core.SessionConfiguration;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.rule.accessor.FactHandleFactory;
import org.drools.kiesession.factory.WorkingMemoryFactory;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.ruleunits.impl.sessions.RuleUnitStatefulKnowledgeSessionImpl;
import org.kie.api.runtime.Environment;

public class RuleUnitPhreakWorkingMemoryFactory implements WorkingMemoryFactory, Serializable {

    private static final WorkingMemoryFactory INSTANCE = new RuleUnitPhreakWorkingMemoryFactory();

    public static WorkingMemoryFactory getInstance() {
        return INSTANCE;
    }

    public InternalWorkingMemory createWorkingMemory(long id, InternalKnowledgeBase kBase, SessionConfiguration config, Environment environment) {
        return new RuleUnitStatefulKnowledgeSessionImpl(id, kBase, true, config, environment);
    }

    public InternalWorkingMemory createWorkingMemory(long id, InternalKnowledgeBase kBase, FactHandleFactory handleFactory, long propagationContext, SessionConfiguration config, InternalAgenda agenda,
            Environment environment) {
        return new RuleUnitStatefulKnowledgeSessionImpl(id, kBase, handleFactory, propagationContext, config, agenda, environment);
    }
}
