/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.impl.datasources;

import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.rule.consequence.InternalMatch;
import org.drools.core.util.bitmask.BitMask;
import org.drools.ruleunits.api.DataHandle;
import org.drools.ruleunits.api.DataProcessor;
import org.drools.ruleunits.api.SingletonStore;
import org.drools.ruleunits.impl.InternalStoreCallback;
import org.drools.ruleunits.impl.datasources.AbstractDataSource;
import org.drools.ruleunits.impl.facthandles.RuleUnitInternalFactHandle;
import org.drools.ruleunits.impl.factory.DataHandleImpl;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.RuleContext;

public class FieldDataStore<T>
extends AbstractDataSource<T>
implements SingletonStore<T>,
InternalStoreCallback {
    private DataHandle handle = null;

    protected FieldDataStore() {
    }

    public DataHandle set(T t) {
        if (this.handle == null && t != null) {
            this.insert(t);
        } else {
            this.clear();
            if (t != null) {
                this.insert(t);
            }
        }
        return this.handle;
    }

    @Override
    public DataHandle lookup(Object object) {
        return this.handle != null && this.handle.getObject() == object ? this.handle : null;
    }

    @Override
    public void addLogical(RuleContext ruleContext, Object object) {
        this.entryPointSubscribers.forEach(eps -> eps.insertLogical(ruleContext, object));
    }

    private void insert(T t) {
        this.handle = this.createDataHandle(t);
        this.forEachSubscriber(s -> this.internalInsert(this.handle, (DataProcessor)s));
    }

    protected DataHandle createDataHandle(T t) {
        return new DataHandleImpl(t);
    }

    public void update() {
        if (this.handle == null) {
            return;
        }
        DataHandle dh = this.handle;
        this.forEachSubscriber(s -> s.update(dh, dh.getObject()));
    }

    public void clear() {
        if (this.handle == null) {
            return;
        }
        DataHandle dh = this.handle;
        this.handle = null;
        this.forEachSubscriber(s -> s.delete(dh));
    }

    @Override
    public void subscribe(DataProcessor processor) {
        super.subscribe(processor);
        if (this.handle != null) {
            this.internalInsert(this.handle, processor);
        }
    }

    @Override
    public void update(RuleUnitInternalFactHandle fh, Object obj, BitMask mask, Class<?> modifiedClass, InternalMatch internalMatch) {
        this.update(fh.getDataHandle(), obj, mask, modifiedClass, internalMatch);
    }

    @Override
    public void update(DataHandle dh, Object obj, BitMask mask, Class<?> modifiedClass, InternalMatch internalMatch) {
        this.entryPointSubscribers.forEach(s -> s.update(dh, obj, mask, modifiedClass, internalMatch));
        this.subscribers.forEach(s -> s.update(dh, obj));
    }

    @Override
    public void delete(RuleUnitInternalFactHandle fh, RuleImpl rule, TerminalNode terminalNode, FactHandle.State fhState) {
        DataHandle dh = fh.getDataHandle();
        if (dh != this.handle) {
            throw new IllegalArgumentException("The given handle is not contained in this DataStore");
        }
        this.entryPointSubscribers.forEach(s -> s.delete(dh, rule, terminalNode, fhState));
        this.subscribers.forEach(s -> s.delete(dh));
        this.handle = null;
    }

    private void internalInsert(DataHandle dh, DataProcessor processor) {
        FactHandle fh = processor.insert(dh, dh == null ? null : dh.getObject());
        if (fh != null) {
            ((RuleUnitInternalFactHandle)fh).setDataStore(this);
            ((RuleUnitInternalFactHandle)fh).setDataHandle(dh);
        }
    }
}

