/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.impl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import org.drools.compiler.builder.conf.DecisionTableConfigurationImpl;
import org.drools.compiler.kie.builder.impl.DrlProject;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieModuleKieProject;
import org.drools.drl.extensions.DecisionTableFactory;
import org.drools.drl.extensions.DecisionTableProvider;
import org.drools.model.codegen.ExecutableModelProject;
import org.drools.model.codegen.execmodel.CanonicalModelKieProject;
import org.drools.ruleunits.api.RuleUnit;
import org.drools.ruleunits.api.RuleUnitData;
import org.drools.ruleunits.api.RuleUnitProvider;
import org.drools.ruleunits.api.conf.RuleConfig;
import org.drools.ruleunits.impl.InternalRuleUnit;
import org.drools.ruleunits.impl.RuleUnitGenerationException;
import org.drools.ruleunits.impl.conf.RuleConfigImpl;
import org.drools.util.IoUtils;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.io.KieResources;
import org.kie.api.io.Resource;
import org.kie.internal.builder.DecisionTableConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleUnitProviderImpl
implements RuleUnitProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuleUnitProviderImpl.class);
    private static final boolean USE_EXEC_MODEL = true;
    private final Map<Class<? extends RuleUnitData>, RuleUnit> ruleUnitMap = this.loadRuleUnits(Thread.currentThread().getContextClassLoader());

    public <T extends RuleUnitData> RuleUnit<T> getRuleUnit(T ruleUnitData) {
        Class<?> ruleUnitDataClass = ruleUnitData.getClass();
        RuleUnit ruleUnit = this.ruleUnitMap.get(ruleUnitDataClass);
        if (ruleUnit != null) {
            return ruleUnit;
        }
        this.ruleUnitMap.putAll(this.generateRuleUnit(ruleUnitData));
        return this.ruleUnitMap.get(ruleUnitDataClass);
    }

    protected <T extends RuleUnitData> Map<Class<? extends RuleUnitData>, RuleUnit> generateRuleUnit(T ruleUnitData) {
        InternalKieModule kieModule = RuleUnitProviderImpl.createRuleUnitKieModule(ruleUnitData.getClass(), true);
        KieModuleKieProject kieModuleKieProject = RuleUnitProviderImpl.createRuleUnitKieProject(kieModule, true);
        return this.loadRuleUnits(kieModuleKieProject.getClassLoader());
    }

    private Map<Class<? extends RuleUnitData>, RuleUnit> loadRuleUnits(ClassLoader classLoader) {
        HashMap<Class<? extends RuleUnitData>, RuleUnit> map = new HashMap<Class<? extends RuleUnitData>, RuleUnit>();
        ServiceLoader<RuleUnit> loader = ServiceLoader.load(RuleUnit.class, classLoader);
        for (RuleUnit impl : loader) {
            map.put(((InternalRuleUnit)impl).getRuleUnitDataClass(), impl);
        }
        return map;
    }

    static InternalKieModule createRuleUnitKieModule(Class<?> unitClass, boolean useExecModel) {
        KieServices ks = KieServices.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        for (Resource drlResource : RuleUnitProviderImpl.ruleResourcesForUnitClass(ks, unitClass)) {
            kfs.write(drlResource);
        }
        return (InternalKieModule)ks.newKieBuilder(kfs).getKieModule(useExecModel ? ExecutableModelProject.class : DrlProject.class);
    }

    static KieModuleKieProject createRuleUnitKieProject(InternalKieModule kieModule, boolean useExecModel) {
        return useExecModel ? new CanonicalModelKieProject(kieModule, kieModule.getModuleClassLoader()) : new KieModuleKieProject(kieModule, kieModule.getModuleClassLoader());
    }

    private static Collection<Resource> ruleResourcesForUnitClass(KieServices ks, Class<?> unitClass) {
        String unitStatement = "unit " + unitClass.getSimpleName();
        HashSet<Resource> resources = new HashSet<Resource>();
        try {
            Enumeration<URL> urlEnumeration = unitClass.getClassLoader().getResources(unitClass.getPackageName().replace('.', '/'));
            while (urlEnumeration.hasMoreElements()) {
                String path = urlEnumeration.nextElement().getPath();
                Optional.ofNullable(new File(path).listFiles()).stream().flatMap(Arrays::stream).filter(f -> RuleUnitProviderImpl.doesDrlContainUnit(f, unitStatement) || RuleUnitProviderImpl.doesXlsContainUnit(f, unitClass.getSimpleName())).map(arg_0 -> ((KieResources)ks.getResources()).newFileSystemResource(arg_0)).forEach(resource -> {
                    LOGGER.debug("Found {} in {} unit", (Object)resource.getSourcePath(), (Object)unitClass.getSimpleName());
                    resources.add((Resource)resource);
                });
            }
        }
        catch (IOException e) {
            throw new RuleUnitGenerationException("Exception while creating KieModule", e);
        }
        return resources;
    }

    private static boolean doesDrlContainUnit(File file, String unitStatement) {
        return file.getName().endsWith(".drl") && IoUtils.readFileAsString((File)file).contains(unitStatement);
    }

    private static boolean doesXlsContainUnit(File file, String unitName) {
        if (file.getName().endsWith(".drl.xls") || file.getName().endsWith(".drl.xlsx")) {
            DecisionTableProvider decisionTableProvider = DecisionTableFactory.getDecisionTableProvider();
            if (decisionTableProvider == null) {
                LOGGER.warn("decision table {} is found, but DecisionTableProvider implementation is not found in the classpath. Please add drools-decisiontables as a dependency", (Object)file.getName());
                return false;
            }
            Map dtableProperties = decisionTableProvider.loadPropertiesFromFile(file, (DecisionTableConfiguration)new DecisionTableConfigurationImpl());
            return RuleUnitProviderImpl.doDecisionTablePropertiesContainUnit(dtableProperties, unitName);
        }
        return false;
    }

    private static boolean doDecisionTablePropertiesContainUnit(Map<String, List<String[]>> dtableProperties, String unitName) {
        List<String[]> unitValues = dtableProperties.get("unit");
        return unitValues != null && unitValues.stream().anyMatch(valueArray -> ((String[])valueArray).length > 0 && valueArray[0] != null && valueArray[0].trim().equals(unitName));
    }

    public RuleConfig newRuleConfig() {
        return new RuleConfigImpl();
    }
}

