/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.impl.datasources;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.drools.ruleunits.api.DataProcessor;
import org.drools.ruleunits.api.DataSource;
import org.drools.ruleunits.impl.EntryPointDataProcessor;

public abstract class AbstractDataSource<T>
implements DataSource<T> {
    protected final List<DataProcessor> subscribers = new CopyOnWriteArrayList<DataProcessor>();
    protected final List<EntryPointDataProcessor> entryPointSubscribers = new CopyOnWriteArrayList<EntryPointDataProcessor>();

    public void subscribe(DataProcessor<T> processor) {
        if (processor instanceof EntryPointDataProcessor) {
            this.entryPointSubscribers.add((EntryPointDataProcessor)processor);
        } else {
            this.subscribers.add(processor);
        }
    }

    protected void forEachSubscriber(Consumer<DataProcessor> consumer) {
        this.subscribers.forEach(consumer);
        this.entryPointSubscribers.forEach(consumer);
    }
}

