/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.core;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.drools.core.common.Storage;
import org.drools.reliability.core.ReliabilityRuntimeException;
import org.drools.reliability.core.SerializableStoredObject;
import org.drools.reliability.core.StoredObject;

public class SerializableStoredRefObject
extends SerializableStoredObject {
    private final Map<String, Long> referencedObjects = new HashMap<String, Long>();

    public SerializableStoredRefObject(Object object, boolean propagated) {
        super(object, propagated);
    }

    public void addReferencedObject(String fieldName, Long refObjectKey) {
        this.referencedObjects.put(fieldName, refObjectKey);
    }

    public StoredObject updateReferencedObjects(Storage<Long, StoredObject> storage) {
        this.referencedObjects.keySet().forEach(fieldName -> {
            Optional<Field> refField = Arrays.stream(this.object.getClass().getDeclaredFields()).filter(f -> f.getName().equals(fieldName)).findFirst();
            if (refField.isPresent()) {
                refField.get().setAccessible(true);
                try {
                    refField.get().set(this.object, ((StoredObject)storage.get((Object)this.referencedObjects.get(refField.get().getName()))).getObject());
                }
                catch (IllegalAccessException e) {
                    throw new ReliabilityRuntimeException(e);
                }
            }
        });
        return this;
    }
}

