/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.core;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.Storage;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.phreak.SynchronizedPropagationList;
import org.drools.reliability.core.StorageManagerFactory;

public class ReliablePropagationList
extends SynchronizedPropagationList
implements Externalizable {
    public static final String PROPAGATION_LIST = "PropagationList";

    public ReliablePropagationList(ReteEvaluator reteEvaluator) {
        super(reteEvaluator);
    }

    public ReliablePropagationList() {
    }

    public void setReteEvaluator(ReteEvaluator reteEvaluator) {
        this.reteEvaluator = reteEvaluator;
    }

    public ReliablePropagationList(ReteEvaluator reteEvaluator, ReliablePropagationList originalList) {
        super(reteEvaluator);
        this.head = originalList.head;
        this.tail = originalList.tail;
    }

    public synchronized PropagationEntry takeAll() {
        PropagationEntry p = super.takeAll();
        Storage componentsStorage = StorageManagerFactory.get().getStorageManager().getOrCreateStorageForSession(this.reteEvaluator, "components");
        componentsStorage.put((Object)PROPAGATION_LIST, (Object)this);
        return p;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.head);
        out.writeObject(this.tail);
        out.writeBoolean(this.disposed);
        out.writeBoolean(this.hasEntriesDeferringExpiration);
        out.writeBoolean(this.firingUntilHalt);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.head = (PropagationEntry)in.readObject();
        this.tail = (PropagationEntry)in.readObject();
        this.disposed = in.readBoolean();
        this.hasEntriesDeferringExpiration = in.readBoolean();
        this.firingUntilHalt = in.readBoolean();
    }
}

