/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.core;

import org.drools.core.common.IdentityObjectStore;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.Storage;
import org.drools.reliability.core.SerializableStoredObject;
import org.drools.reliability.core.StoredObject;

public class FullReliableObjectStore
extends IdentityObjectStore {
    private final transient Storage<Long, StoredObject> storage;

    public FullReliableObjectStore() {
        this.storage = null;
    }

    public FullReliableObjectStore(Storage<Long, StoredObject> storage) {
        this.storage = storage;
    }

    public void addHandle(InternalFactHandle handle, Object object) {
        super.addHandle(handle, object);
        this.putIntoPersistedCache(handle, handle.hasMatches());
    }

    public void removeHandle(InternalFactHandle handle) {
        this.removeFromPersistedCache(handle.getObject());
        super.removeHandle(handle);
    }

    void putIntoPersistedCache(InternalFactHandle handle, boolean propagated) {
        Object object = handle.getObject();
        SerializableStoredObject storedObject = new SerializableStoredObject(object, propagated);
        this.storage.put((Object)this.getHandleForObject(object).getId(), (Object)storedObject);
    }

    void removeFromPersistedCache(Object object) {
        InternalFactHandle fh = this.getHandleForObject(object);
        if (fh != null) {
            this.storage.remove((Object)fh.getId());
        }
    }

    public void reInit() {
        for (StoredObject entry : this.storage.values()) {
            super.addHandle(this.getHandleForObject(entry.getObject()), entry.getObject());
        }
    }
}

