/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.core;

import org.drools.core.common.Storage;
import org.drools.reliability.core.ReliableGlobalResolver;
import org.kie.api.internal.utils.KieService;

public interface ReliableGlobalResolverFactory
extends KieService {
    public ReliableGlobalResolver createReliableGlobalResolver(Storage<String, Object> var1);

    public static ReliableGlobalResolverFactory get() {
        return Holder.INSTANCE;
    }

    public static ReliableGlobalResolverFactory get(String reliabilityPersistanceLayer) {
        if (Tag.reliabilityPersistanceLayer != null && !Tag.reliabilityPersistanceLayer.equals(reliabilityPersistanceLayer)) {
            throw new IllegalStateException("You must call the same service with the same reliabilityPersistanceLayer. Previous reliabilityPersistanceLayer was " + Tag.reliabilityPersistanceLayer + " and current reliabilityPersistanceLayer is " + reliabilityPersistanceLayer);
        }
        Tag.reliabilityPersistanceLayer = reliabilityPersistanceLayer;
        return Holder.INSTANCE;
    }

    public static class ReliableGlobalResolverFactoryImpl
    implements ReliableGlobalResolverFactory {
        @Override
        public ReliableGlobalResolver createReliableGlobalResolver(Storage<String, Object> storage) {
            return new ReliableGlobalResolver(storage);
        }

        public int servicePriority() {
            return 0;
        }

        public String serviceTag() {
            return "core";
        }
    }

    public static class Holder {
        private static final ReliableGlobalResolverFactory INSTANCE = Holder.createInstance();

        private Holder() {
        }

        static ReliableGlobalResolverFactory createInstance() {
            ReliableGlobalResolverFactory factory = (ReliableGlobalResolverFactory)KieService.loadWithTag(ReliableGlobalResolverFactory.class, (String)Tag.reliabilityPersistanceLayer);
            if (factory == null) {
                return new ReliableGlobalResolverFactoryImpl();
            }
            return factory;
        }
    }

    public static class Tag {
        private static String reliabilityPersistanceLayer = null;

        private Tag() {
        }
    }
}

