/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.core;

import org.drools.reliability.core.ReliabilityConfigurationException;
import org.drools.reliability.core.StorageManager;
import org.kie.api.internal.utils.KieService;

public interface StorageManagerFactory
extends KieService {
    public static final String SESSION_STORAGE_PREFIX = "session_";
    public static final String SHARED_STORAGE_PREFIX = "shared_";
    public static final String DELIMITER = "_";
    public static final String RELIABILITY_STORAGE_PREFIX = "drools.reliability.storage";

    public StorageManager getStorageManager();

    public static StorageManagerFactory get() {
        return Holder.INSTANCE;
    }

    public static StorageManagerFactory get(String reliabilityPersistanceLayer) {
        if (Tag.reliabilityPersistanceLayer != null && !Tag.reliabilityPersistanceLayer.equals(reliabilityPersistanceLayer)) {
            throw new IllegalStateException("You must call the same service with the same reliabilityPersistanceLayer. Previous reliabilityPersistanceLayer was " + Tag.reliabilityPersistanceLayer + " and current reliabilityPersistanceLayer is " + reliabilityPersistanceLayer);
        }
        Tag.reliabilityPersistanceLayer = reliabilityPersistanceLayer;
        return Holder.INSTANCE;
    }

    public static <T> T throwExceptionForMissingRuntime() {
        throw new ReliabilityConfigurationException("Cannot find any persistence implementation");
    }

    public static class Holder {
        private static final StorageManagerFactory INSTANCE = Holder.createInstance();

        private Holder() {
        }

        static StorageManagerFactory createInstance() {
            StorageManagerFactory factory = (StorageManagerFactory)KieService.loadWithTag(StorageManagerFactory.class, (String)Tag.reliabilityPersistanceLayer);
            if (factory == null) {
                StorageManagerFactory.throwExceptionForMissingRuntime();
                return null;
            }
            factory.getStorageManager().initStorageManager();
            return factory;
        }
    }

    public static class Tag {
        private static String reliabilityPersistanceLayer = null;

        private Tag() {
        }
    }
}

