/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.core;

import java.util.Set;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.Storage;
import org.drools.reliability.core.BatchingStorageDecorator;
import org.drools.reliability.core.ReliabilityConfigurationException;
import org.kie.api.runtime.conf.PersistedSessionOption;

public interface StorageManager {
    public void initStorageManager();

    default public <K, V> Storage<K, V> getOrCreateStorageForSession(ReteEvaluator reteEvaluator, String storageName) {
        return this.getOrCreateStorageForSession(reteEvaluator, reteEvaluator.getSessionConfiguration().getPersistedSessionOption().getSafepointStrategy(), storageName);
    }

    default public <K, V> Storage<K, V> getOrCreateStorageForSession(ReteEvaluator reteEvaluator, PersistedSessionOption.SafepointStrategy safepointStrategy, String storageName) {
        Storage<K, V> storage = this.internalGetOrCreateStorageForSession(reteEvaluator, storageName);
        if (safepointStrategy.useSafepoints()) {
            storage = new BatchingStorageDecorator<K, V>(storage);
        }
        return storage;
    }

    public <K, V> Storage<K, V> internalGetOrCreateStorageForSession(ReteEvaluator var1, String var2);

    public <K, V> Storage<K, V> getOrCreateSharedStorage(String var1);

    public void close();

    public void removeStorage(String var1);

    public void removeStoragesBySessionId(String var1);

    public void removeAllSessionStorages();

    public Set<String> getStorageNames();

    public static String createStorageId(ReteEvaluator reteEvaluator, String storageName) {
        return "session_" + StorageManager.getSessionIdentifier(reteEvaluator) + "_" + storageName;
    }

    public static long getSessionIdentifier(ReteEvaluator reteEvaluator) {
        PersistedSessionOption persistedSessionOption = reteEvaluator.getSessionConfiguration().getPersistedSessionOption();
        if (persistedSessionOption != null) {
            return persistedSessionOption.isNewSession() ? reteEvaluator.getIdentifier() : persistedSessionOption.getSessionId();
        }
        throw new ReliabilityConfigurationException("PersistedSessionOption has to be configured when drools-reliability is used");
    }
}

