/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.core;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.drools.core.ClockType;
import org.drools.core.common.DefaultEventHandle;
import org.drools.core.common.IdentityObjectStore;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.Storage;
import org.drools.reliability.core.ReliablePseudoClockScheduler;
import org.drools.reliability.core.SerializableStoredObject;
import org.drools.reliability.core.SimpleReliableObjectStore;
import org.drools.reliability.core.StoredObject;

public class SimpleSerializationReliableObjectStore
extends IdentityObjectStore
implements SimpleReliableObjectStore {
    protected final transient Storage<Long, StoredObject> storage;
    protected boolean reInitPropagated = false;

    public SimpleSerializationReliableObjectStore() {
        throw new UnsupportedOperationException("This constructor should never be called");
    }

    public SimpleSerializationReliableObjectStore(Storage<Long, StoredObject> storage) {
        this.storage = storage;
    }

    public void addHandle(InternalFactHandle handle, Object object) {
        super.addHandle(handle, object);
        this.putIntoPersistedStorage(handle, handle.hasMatches());
    }

    public void removeHandle(InternalFactHandle handle) {
        this.removeFromPersistedStorage(handle.getObject());
        super.removeHandle(handle);
    }

    @Override
    public List<StoredObject> reInit(InternalWorkingMemory session, InternalWorkingMemoryEntryPoint ep) {
        this.reInitPropagated = true;
        ArrayList<StoredObject> propagated = new ArrayList<StoredObject>();
        ArrayList<StoredObject> notPropagated = new ArrayList<StoredObject>();
        for (StoredObject entry : this.storage.values()) {
            if (entry.isPropagated()) {
                propagated.add(entry);
                continue;
            }
            notPropagated.add(entry);
        }
        this.storage.clear();
        if (session.getSessionConfiguration().getClockType() == ClockType.PSEUDO_CLOCK) {
            this.repropagateWithPseudoClock(session, ep, propagated);
        } else {
            propagated.forEach(obj -> obj.repropagate(ep));
            session.fireAllRules(match -> false);
        }
        this.reInitPropagated = false;
        return notPropagated;
    }

    private void repropagateWithPseudoClock(InternalWorkingMemory session, InternalWorkingMemoryEntryPoint ep, List<StoredObject> propagated) {
        ReliablePseudoClockScheduler clock = (ReliablePseudoClockScheduler)session.getSessionClock();
        for (StoredObject storedObject : propagated) {
            long timestamp;
            long currentTime;
            if (storedObject.isEvent() && (currentTime = clock.getCurrentTime()) < (timestamp = storedObject.getTimestamp())) {
                clock.advanceTime(timestamp - currentTime, TimeUnit.MILLISECONDS);
            }
            storedObject.repropagate(ep);
        }
        session.fireAllRules(match -> false);
        long currentTime = clock.getCurrentTime();
        long persistedTime = clock.getPersistedTimer().longValue();
        if (currentTime < persistedTime) {
            clock.advanceTime(persistedTime - currentTime, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void putIntoPersistedStorage(InternalFactHandle handle, boolean propagated) {
        Object object = handle.getObject();
        StoredObject storedObject = this.factHandleToStoredObject(handle, this.reInitPropagated || propagated, object);
        this.storage.put((Object)this.getHandleForObject(object).getId(), (Object)storedObject);
    }

    private StoredObject factHandleToStoredObject(InternalFactHandle handle, boolean propagated, Object object) {
        return handle.isEvent() ? this.createStoredObject(propagated, object, ((DefaultEventHandle)handle).getStartTimestamp(), ((DefaultEventHandle)handle).getDuration(), handle.getId()) : this.createStoredObject(propagated, object);
    }

    protected StoredObject createStoredObject(boolean propagated, Object object) {
        return new SerializableStoredObject(object, propagated);
    }

    protected StoredObject createStoredObject(boolean propagated, Object object, long timestamp, long duration, long handleId) {
        return new SerializableStoredObject(object, propagated, timestamp, duration, handleId);
    }

    @Override
    public void removeFromPersistedStorage(Object object) {
        InternalFactHandle fh = this.getHandleForObject(object);
        if (fh != null) {
            this.storage.remove((Object)fh.getId());
        }
    }

    @Override
    public void safepoint() {
        if (this.storage.requiresFlush()) {
            this.storage.flush();
        }
    }
}

