/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.core;

import java.util.concurrent.atomic.AtomicLong;
import org.drools.base.RuleBase;
import org.drools.base.rule.accessor.GlobalResolver;
import org.drools.core.SessionConfiguration;
import org.drools.core.common.AgendaFactory;
import org.drools.core.common.EntryPointFactory;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.Storage;
import org.drools.core.time.TimerService;
import org.drools.kiesession.factory.RuntimeComponentFactoryImpl;
import org.drools.kiesession.factory.WorkingMemoryFactory;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.reliability.core.ReliableAgendaFactory;
import org.drools.reliability.core.ReliableGlobalResolver;
import org.drools.reliability.core.ReliableNamedEntryPointFactory;
import org.drools.reliability.core.ReliablePhreakWorkingMemoryFactory;
import org.drools.reliability.core.ReliablePseudoClockScheduler;
import org.drools.reliability.core.ReliableSessionInitializer;
import org.drools.reliability.core.StorageManagerFactory;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.PersistedSessionOption;

public class ReliableRuntimeComponentFactoryImpl
extends RuntimeComponentFactoryImpl {
    private static final AtomicLong RELIABLE_SESSIONS_COUNTER = new AtomicLong(0L);
    private static final String NEXT_SESSION_ID = "nextSessionId";
    private final transient WorkingMemoryFactory wmFactory = ReliablePhreakWorkingMemoryFactory.getInstance();
    private final transient AgendaFactory agendaFactory = ReliableAgendaFactory.getInstance();

    public ReliableRuntimeComponentFactoryImpl() {
        ReliableRuntimeComponentFactoryImpl.refreshReliableSessionsCounterUsingStorage();
    }

    private static void refreshReliableSessionsCounterUsingStorage() {
        Storage sessionsCounter = StorageManagerFactory.get().getStorageManager().getOrCreateSharedStorage("sessionsCounter");
        if (sessionsCounter.containsKey((Object)NEXT_SESSION_ID)) {
            RELIABLE_SESSIONS_COUNTER.set((Long)sessionsCounter.get((Object)NEXT_SESSION_ID));
        } else {
            sessionsCounter.put((Object)NEXT_SESSION_ID, (Object)RELIABLE_SESSIONS_COUNTER.get());
        }
    }

    public EntryPointFactory getEntryPointFactory() {
        return new ReliableNamedEntryPointFactory();
    }

    public InternalWorkingMemory createStatefulSession(RuleBase ruleBase, Environment environment, SessionConfiguration sessionConfig, boolean fromPool) {
        if (!sessionConfig.hasPersistedSessionOption()) {
            return super.createStatefulSession(ruleBase, environment, sessionConfig, fromPool);
        }
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)ruleBase;
        if (fromPool || kbase.getSessionPool() == null) {
            InternalWorkingMemory session = this.wmFactory.createWorkingMemory(RELIABLE_SESSIONS_COUNTER.getAndIncrement(), kbase, sessionConfig, environment);
            this.updateSessionsCounter();
            return this.internalInitSession(kbase, sessionConfig, session);
        }
        return (InternalWorkingMemory)kbase.getSessionPool().newKieSession((KieSessionConfiguration)sessionConfig);
    }

    private void updateSessionsCounter() {
        Storage sessionsCounter = StorageManagerFactory.get().getStorageManager().getOrCreateSharedStorage("sessionsCounter");
        sessionsCounter.put((Object)NEXT_SESSION_ID, (Object)RELIABLE_SESSIONS_COUNTER.get());
    }

    public GlobalResolver createGlobalResolver(ReteEvaluator reteEvaluator, Environment environment) {
        if (!reteEvaluator.getSessionConfiguration().hasPersistedSessionOption()) {
            return super.createGlobalResolver(reteEvaluator, environment);
        }
        return new ReliableGlobalResolver(StorageManagerFactory.get().getStorageManager().getOrCreateStorageForSession(reteEvaluator, PersistedSessionOption.SafepointStrategy.ALWAYS, "globals"));
    }

    public TimerService createTimerService(ReteEvaluator reteEvaluator) {
        if (!reteEvaluator.getSessionConfiguration().hasPersistedSessionOption()) {
            return super.createTimerService(reteEvaluator);
        }
        return new ReliablePseudoClockScheduler(StorageManagerFactory.get().getStorageManager().getOrCreateStorageForSession(reteEvaluator, PersistedSessionOption.SafepointStrategy.ALWAYS, "timer"));
    }

    private InternalWorkingMemory internalInitSession(InternalKnowledgeBase kbase, SessionConfiguration sessionConfig, InternalWorkingMemory session) {
        if (sessionConfig.isKeepReference()) {
            kbase.addStatefulSession(session);
        }
        return ReliableSessionInitializer.initReliableSession(sessionConfig, session);
    }

    public AgendaFactory getAgendaFactory(SessionConfiguration sessionConfig) {
        if (!sessionConfig.hasPersistedSessionOption() || sessionConfig.getPersistedSessionOption().getPersistenceStrategy() == PersistedSessionOption.PersistenceStrategy.STORES_ONLY) {
            return super.getAgendaFactory(sessionConfig);
        }
        return this.agendaFactory;
    }

    public static void resetCounter() {
        RELIABLE_SESSIONS_COUNTER.set(0L);
    }

    public static void refreshCounterUsingStorage() {
        ReliableRuntimeComponentFactoryImpl.refreshReliableSessionsCounterUsingStorage();
    }

    public int servicePriority() {
        return 1;
    }
}

