/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.core;

import java.io.Serializable;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.DefaultEventHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.rule.accessor.FactHandleFactory;
import org.drools.reliability.core.StoredObject;

public abstract class BaseStoredObject
implements StoredObject,
Serializable {
    protected final boolean propagated;
    protected final long timestamp;
    protected final long duration;
    protected final long handleId;

    protected BaseStoredObject(boolean propagated, long timestamp, long duration, long handleId) {
        this.propagated = propagated;
        this.timestamp = timestamp;
        this.duration = duration;
        this.handleId = handleId;
    }

    @Override
    public boolean isEvent() {
        return this.timestamp >= 0L;
    }

    @Override
    public boolean isPropagated() {
        return this.propagated;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public void repropagate(InternalWorkingMemoryEntryPoint ep) {
        if (this.isEvent()) {
            FactHandleFactory fhFactory = ep.getHandleFactory();
            DefaultEventHandle eFh = fhFactory.createEventFactHandle(fhFactory.getNextId(), this.getObject(), fhFactory.getNextRecency(), (WorkingMemoryEntryPoint)ep, this.timestamp, this.duration);
            ep.insert((InternalFactHandle)eFh);
        } else {
            ep.insert(this.getObject());
        }
    }
}

