/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.drools.core.common.DefaultEventHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.Storage;
import org.drools.core.impl.WorkingMemoryReteExpireAction;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.time.JobContext;
import org.drools.core.time.impl.DefaultTimerJobInstance;
import org.drools.core.time.impl.PseudoClockScheduler;
import org.drools.core.time.impl.TimerJobInstance;
import org.drools.reliability.core.ReliabilityRuntimeException;

public class ReliablePseudoClockScheduler
extends PseudoClockScheduler {
    private final transient Storage<String, Object> storage;
    private transient ReteEvaluator reteEvaluator;
    private transient Map<String, Map<Long, DefaultEventHandle>> eventHandleMap = new HashMap<String, Map<Long, DefaultEventHandle>>();

    public ReliablePseudoClockScheduler() {
        throw new UnsupportedOperationException("This constructor should not be used");
    }

    public ReliablePseudoClockScheduler(Storage<String, Object> storage, ReteEvaluator reteEvaluator) {
        this.storage = storage;
        this.timer = new AtomicLong((Long)storage.getOrDefault((Object)"timer", (Object)0L));
        this.idCounter = new AtomicLong((Long)storage.getOrDefault((Object)"idCounter", (Object)0L));
        this.queue = (PriorityQueue)storage.getOrDefault((Object)"queue", new PriorityQueue());
        this.reteEvaluator = reteEvaluator;
    }

    public long advanceTime(long amount, TimeUnit unit) {
        long time = super.advanceTime(amount, unit);
        this.updateStorage();
        return time;
    }

    private void updateStorage() {
        this.storage.put((Object)"timer", (Object)this.timer.get());
        this.storage.put((Object)"idCounter", (Object)this.idCounter.get());
        this.storage.put((Object)"queue", (Object)this.queue);
    }

    public void putHandleIdAssociation(long oldHandleId, DefaultEventHandle eFh) {
        String entryPointName = eFh.getEntryPointName();
        Map eventHandleMapPerEntryPoint = this.eventHandleMap.computeIfAbsent(entryPointName, key -> new HashMap());
        eventHandleMapPerEntryPoint.put(oldHandleId, eFh);
    }

    public void rewireTimerJobs() {
        ArrayList toBeRemoved = new ArrayList();
        this.queue.stream().filter(DefaultTimerJobInstance.class::isInstance).map(DefaultTimerJobInstance.class::cast).forEach(job -> this.rewireTimerJob((DefaultTimerJobInstance)job, toBeRemoved));
        this.queue.removeAll(toBeRemoved);
        this.eventHandleMap.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void rewireTimerJob(DefaultTimerJobInstance jobInstance, List<TimerJobInstance> toBeRemoved) {
        JobContext jobContext = jobInstance.getJobContext();
        if (!(jobContext instanceof ObjectTypeNode.ExpireJobContext)) return;
        ObjectTypeNode.ExpireJobContext expireJobContext = (ObjectTypeNode.ExpireJobContext)jobContext;
        expireJobContext.setReteEvaluator(this.reteEvaluator);
        WorkingMemoryReteExpireAction expireAction = expireJobContext.getExpireAction();
        if (expireAction.getFactHandle().getObject() == null) {
            String entryPointName = expireAction.getFactHandle().getEntryPointName();
            long oldHandleId = expireAction.getFactHandle().getId();
            if (!this.eventHandleMap.containsKey(entryPointName) || !this.eventHandleMap.get(entryPointName).containsKey(oldHandleId)) throw new ReliabilityRuntimeException("new handle to rewire is not found : entryPointName = " + entryPointName + ", oldHandleId = " + oldHandleId);
            expireAction.setFactHandle(this.eventHandleMap.get(entryPointName).get(oldHandleId));
            return;
        } else {
            toBeRemoved.add((TimerJobInstance)jobInstance);
        }
    }
}

