/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.constraints;

import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import org.drools.base.base.ValueResolver;
import org.drools.base.reteoo.BaseTuple;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.accessor.Accumulator;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.reteoo.SubnetworkTuple;
import org.drools.modelcompiler.constraints.BindingEvaluator;
import org.kie.api.runtime.rule.AccumulateFunction;
import org.kie.api.runtime.rule.FactHandle;

public abstract class LambdaAccumulator
implements Accumulator {
    private final AccumulateFunction accumulateFunction;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LambdaAccumulator that = (LambdaAccumulator)o;
        return Objects.equals(this.accumulateFunction, that.accumulateFunction);
    }

    public int hashCode() {
        return Objects.hash(this.accumulateFunction);
    }

    protected LambdaAccumulator(AccumulateFunction accumulateFunction) {
        this.accumulateFunction = accumulateFunction;
    }

    public Object createWorkingMemoryContext() {
        return null;
    }

    public Object createContext() {
        return this.accumulateFunction.createContext();
    }

    public Object init(Object workingMemoryContext, Object context, BaseTuple leftTuple, Declaration[] declarations, ValueResolver valueResolver) {
        context = this.accumulateFunction.initContext((Serializable)context);
        return context;
    }

    public Object accumulate(Object workingMemoryContext, Object context, BaseTuple leftTuple, FactHandle handle, Declaration[] declarations, Declaration[] innerDeclarations, ValueResolver valueResolver) {
        Object accumulatedObject = this.getAccumulatedObject(declarations, innerDeclarations, handle, leftTuple, (ReteEvaluator)valueResolver);
        return this.accumulateFunction.accumulateValue((Serializable)context, accumulatedObject);
    }

    protected abstract Object getAccumulatedObject(Declaration[] var1, Declaration[] var2, FactHandle var3, BaseTuple var4, ReteEvaluator var5);

    public boolean supportsReverse() {
        return this.accumulateFunction.supportsReverse();
    }

    public boolean tryReverse(Object workingMemoryContext, Object context, BaseTuple leftTuple, FactHandle handle, Object value, Declaration[] declarations, Declaration[] innerDeclarations, ValueResolver valueResolver) {
        if (value == null) {
            throw new IllegalStateException("Reversing a not existing accumulated object for fact " + handle);
        }
        return this.accumulateFunction.tryReverse((Serializable)context, value);
    }

    public Object getResult(Object workingMemoryContext, Object context, BaseTuple leftTuple, Declaration[] declarations, ValueResolver valueResolver) {
        try {
            return this.accumulateFunction.getResult((Serializable)context);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class FixedValueAcc
    extends LambdaAccumulator {
        private final Object value;

        public FixedValueAcc(AccumulateFunction accumulateFunction, Object value) {
            super(accumulateFunction);
            this.value = value;
        }

        @Override
        protected Object getAccumulatedObject(Declaration[] declarations, Declaration[] innerDeclarations, FactHandle handle, BaseTuple tuple, ReteEvaluator reteEvaluator) {
            return this.value;
        }
    }

    public static class NotBindingAcc
    extends LambdaAccumulator {
        public NotBindingAcc(AccumulateFunction accumulateFunction) {
            super(accumulateFunction);
        }

        @Override
        protected Object getAccumulatedObject(Declaration[] declarations, Declaration[] innerDeclarations, FactHandle handle, BaseTuple tuple, ReteEvaluator reteEvaluator) {
            Object accumulateObject = handle.getObject();
            if (accumulateObject instanceof SubnetworkTuple && declarations.length > 0) {
                return declarations[0].getValue((BaseTuple)((SubnetworkTuple)accumulateObject));
            }
            return accumulateObject;
        }
    }

    public static class BindingAcc
    extends LambdaAccumulator {
        private final BindingEvaluator binding;
        private final Collection<String> sourceVariables;

        public BindingAcc(AccumulateFunction accumulateFunction, Collection<String> sourceVariables, BindingEvaluator binding) {
            super(accumulateFunction);
            this.binding = binding;
            this.sourceVariables = sourceVariables;
        }

        @Override
        protected Object getAccumulatedObject(Declaration[] declarations, Declaration[] innerDeclarations, FactHandle handle, BaseTuple tuple, ReteEvaluator reteEvaluator) {
            Object accumulateObject = handle.getObject();
            if (accumulateObject instanceof SubnetworkTuple) {
                Object[] args;
                Declaration[] bindingDeclarations = this.binding.getDeclarations();
                if (bindingDeclarations == null || bindingDeclarations.length == 0) {
                    args = new Object[this.sourceVariables.size()];
                    int i = 0;
                    for (String sourceVariable : this.sourceVariables) {
                        for (Declaration d : innerDeclarations) {
                            if (!d.getIdentifier().equals(sourceVariable)) continue;
                            args[i] = d.getValue((BaseTuple)((SubnetworkTuple)accumulateObject));
                            break;
                        }
                        ++i;
                    }
                } else {
                    args = new Object[bindingDeclarations.length];
                    for (int i = 0; i < bindingDeclarations.length; ++i) {
                        args[i] = bindingDeclarations[i].getValue((BaseTuple)((SubnetworkTuple)accumulateObject));
                    }
                }
                return this.binding.evaluate(args);
            }
            return this.binding.evaluate(handle, tuple, (ValueResolver)reteEvaluator, declarations, innerDeclarations);
        }
    }
}

