/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.facttemplate;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.drools.base.facttemplates.Fact;
import org.drools.base.facttemplates.FactTemplate;
import org.drools.model.PrototypeFact;

public class HashMapFactImpl
implements Fact,
PrototypeFact,
Serializable {
    protected final UUID uuid = UUID.randomUUID();
    protected final FactTemplate factTemplate;
    protected final Map<String, Object> valuesMap;

    public HashMapFactImpl(FactTemplate factTemplate) {
        this(factTemplate, new HashMap<String, Object>());
    }

    public HashMapFactImpl(FactTemplate factTemplate, Map<String, Object> valuesMap) {
        this.factTemplate = factTemplate;
        this.valuesMap = valuesMap;
    }

    public FactTemplate getFactTemplate() {
        return this.factTemplate;
    }

    public boolean has(String name) {
        return this.valuesMap.containsKey(name);
    }

    public Object get(String name) {
        return this.valuesMap.get(name);
    }

    public void set(String name, Object value) {
        this.valuesMap.put(name, value);
    }

    public Map<String, Object> asMap() {
        return this.valuesMap;
    }

    public String toString() {
        return "Fact " + this.factTemplate.getName() + " with values = " + this.valuesMap;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HashMapFactImpl other = (HashMapFactImpl)obj;
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }
}

