/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.consequence;

import java.util.ArrayList;
import java.util.Collections;
import org.drools.base.base.ValueResolver;
import org.drools.base.reteoo.BaseTuple;
import org.drools.base.rule.Declaration;
import org.drools.core.common.DefaultEventHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.rule.consequence.KnowledgeHelper;
import org.drools.model.Consequence;
import org.drools.model.Variable;
import org.drools.modelcompiler.consequence.DroolsImpl;
import org.drools.modelcompiler.consequence.FactHandleLookup;
import org.kie.api.runtime.rule.FactHandle;

public class LambdaConsequence
implements org.drools.base.rule.consequence.Consequence<KnowledgeHelper> {
    private static final boolean ENABLE_LINEARIZED_ARGUMENTS_RETRIEVAL_OPTIMIZATION = true;
    private final Consequence consequence;
    private final boolean enabledTupleOptimization;
    private Declaration[] requiredDeclarations;
    private TupleFactSupplier[] factSuppliers;
    private GlobalSupplier[] globalSuppliers;
    private Object[] facts;
    private FactHandleLookup fhLookup;

    public LambdaConsequence(Consequence consequence, boolean enabledTupleOptimization) {
        this.consequence = consequence;
        this.enabledTupleOptimization = true & enabledTupleOptimization;
    }

    public String getName() {
        return "default";
    }

    public void evaluate(KnowledgeHelper knowledgeHelper, ValueResolver valueResolver) throws Exception {
        if (this.requiredDeclarations == null) {
            Declaration[] declarations = ((RuleTerminalNode)knowledgeHelper.getMatch().getTuple().getTupleSink()).getRequiredDeclarations();
            if (this.enabledTupleOptimization) {
                this.requiredDeclarations = declarations;
            } else {
                Object[] facts = LambdaConsequence.declarationsToFacts(knowledgeHelper, valueResolver, knowledgeHelper.getTuple(), declarations, this.consequence.getVariables(), this.consequence.isUsingDrools());
                this.consequence.getBlock().execute(facts);
                return;
            }
        }
        this.consequence.getBlock().execute(this.fetchFacts(knowledgeHelper, valueResolver));
    }

    public static Object[] declarationsToFacts(ValueResolver reteEvaluator, BaseTuple tuple, Declaration[] declarations, Variable[] vars) {
        return LambdaConsequence.declarationsToFacts(null, reteEvaluator, tuple, declarations, vars, false);
    }

    private static Object[] declarationsToFacts(KnowledgeHelper knowledgeHelper, ValueResolver valueResolver, BaseTuple tuple, Declaration[] declarations, Variable[] vars, boolean useDrools) {
        Object[] objects;
        FactHandleLookup.Multi fhLookup = useDrools ? new FactHandleLookup.Multi() : null;
        int index = 0;
        if (useDrools) {
            ++index;
            objects = new Object[vars.length + 1];
            objects[0] = new DroolsImpl(knowledgeHelper, valueResolver, fhLookup);
        } else {
            objects = new Object[vars.length];
        }
        int declrCounter = 0;
        for (Variable var : vars) {
            if (var.isFact()) {
                Declaration declaration = declarations[declrCounter++];
                FactHandle fh = LambdaConsequence.getOriginalFactHandle(tuple.get(declaration));
                if (useDrools) {
                    fhLookup.put(fh.getObject(), fh);
                }
                objects[index++] = declaration.getValue(valueResolver, fh);
                continue;
            }
            objects[index++] = valueResolver.getGlobal(var.getName());
        }
        return objects;
    }

    private static FactHandle getOriginalFactHandle(FactHandle handle) {
        if (!handle.isEvent()) {
            return handle;
        }
        DefaultEventHandle linkedFH = ((DefaultEventHandle)handle).getLinkedFactHandle();
        return linkedFH != null ? linkedFH : handle;
    }

    private Object[] fetchFacts(KnowledgeHelper knowledgeHelper, ValueResolver valueResolver) {
        int j;
        Object[] facts;
        ReteEvaluator reteEvaluator = (ReteEvaluator)valueResolver;
        if (this.factSuppliers == null) {
            return this.initConsequence(knowledgeHelper, reteEvaluator);
        }
        FactHandleLookup fhLookup = null;
        if (reteEvaluator.getRuleSessionConfiguration().isThreadSafe()) {
            if (this.consequence.isUsingDrools()) {
                facts = new Object[this.consequence.getVariables().length + 1];
                fhLookup = FactHandleLookup.create(this.factSuppliers.length);
                facts[0] = new DroolsImpl(knowledgeHelper, (ValueResolver)reteEvaluator, fhLookup);
            } else {
                facts = new Object[this.consequence.getVariables().length];
            }
        } else {
            facts = this.facts;
            if (this.consequence.isUsingDrools()) {
                fhLookup = this.fhLookup;
                fhLookup.clear();
                facts[0] = new DroolsImpl(knowledgeHelper, (ValueResolver)reteEvaluator, fhLookup);
            }
        }
        BaseTuple tuple = knowledgeHelper.getTuple();
        for (j = 0; j < this.factSuppliers.length; ++j) {
            tuple = this.factSuppliers[j].resolveAndStore(facts, (ValueResolver)reteEvaluator, tuple, fhLookup);
        }
        if (this.globalSuppliers != null) {
            for (j = 0; j < this.globalSuppliers.length; ++j) {
                this.globalSuppliers[j].resolveAndStore(facts, reteEvaluator);
            }
        }
        return facts;
    }

    private Object[] initConsequence(KnowledgeHelper knowledgeHelper, ReteEvaluator reteEvaluator) {
        Object[] facts;
        Variable[] vars = this.consequence.getVariables();
        if (vars.length == 0) {
            Object[] objectArray;
            if (this.consequence.isUsingDrools()) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = new DroolsImpl(knowledgeHelper, (ValueResolver)reteEvaluator, null);
            } else {
                objectArray = new Object[]{};
            }
            return objectArray;
        }
        BaseTuple tuple = knowledgeHelper.getTuple();
        ArrayList<TupleFactSupplier> factSuppliers = new ArrayList<TupleFactSupplier>();
        ArrayList<GlobalSupplier> globalSuppliers = new ArrayList<GlobalSupplier>();
        int supplierIndex = 0;
        if (this.consequence.isUsingDrools()) {
            facts = new Object[vars.length + 1];
            ++supplierIndex;
        } else {
            facts = new Object[vars.length];
            this.fhLookup = null;
        }
        int declrCounter = 0;
        for (Variable var : vars) {
            if (var.isFact()) {
                factSuppliers.add(new TupleFactSupplier(supplierIndex, this.requiredDeclarations[declrCounter++], this.consequence.isUsingDrools()));
            } else {
                facts[supplierIndex] = reteEvaluator.getGlobal(var.getName());
                globalSuppliers.add(new GlobalSupplier(supplierIndex, var.getName()));
            }
            ++supplierIndex;
        }
        FactHandleLookup fhLookup = null;
        if (this.consequence.isUsingDrools()) {
            fhLookup = FactHandleLookup.create(factSuppliers.size());
            facts[0] = new DroolsImpl(knowledgeHelper, (ValueResolver)reteEvaluator, fhLookup);
        }
        Collections.sort(factSuppliers);
        Collections.sort(globalSuppliers);
        BaseTuple current = tuple;
        boolean first = true;
        for (TupleFactSupplier tupleFactSupplier : factSuppliers) {
            int targetTupleIndex = tupleFactSupplier.declarationTupleIndex;
            tupleFactSupplier.offsetFromPrior = 0;
            while (current.getIndex() != targetTupleIndex) {
                ++tupleFactSupplier.offsetFromPrior;
                current = current.getParent();
            }
            tupleFactSupplier.setFirst(first);
            first = false;
            tupleFactSupplier.resolveAndStore(facts, (ValueResolver)reteEvaluator, current.getFactHandle(), fhLookup);
        }
        this.globalSuppliers = globalSuppliers.isEmpty() ? null : globalSuppliers.toArray(new GlobalSupplier[globalSuppliers.size()]);
        this.factSuppliers = factSuppliers.toArray(new TupleFactSupplier[factSuppliers.size()]);
        if (!reteEvaluator.getRuleSessionConfiguration().isThreadSafe()) {
            this.facts = facts;
            this.fhLookup = fhLookup;
        }
        return facts;
    }

    private static class TupleFactSupplier
    implements Comparable<TupleFactSupplier> {
        private final int supplierIndex;
        private final Declaration declaration;
        private final int declarationTupleIndex;
        private boolean useDrools;
        private int offsetFromPrior;

        private TupleFactSupplier(int supplierIndex, Declaration declaration, boolean useDrools) {
            this.supplierIndex = supplierIndex;
            this.declaration = declaration;
            this.declarationTupleIndex = declaration.getTupleIndex();
            this.useDrools = useDrools;
        }

        private void setFirst(boolean first) {
            if (!first) {
                this.useDrools &= this.offsetFromPrior > 0;
            }
        }

        public BaseTuple resolveAndStore(Object[] facts, ValueResolver reteEvaluator, BaseTuple tuple, FactHandleLookup fhLookup) {
            for (int i = 0; i < this.offsetFromPrior; ++i) {
                tuple = tuple.getParent();
            }
            this.resolveAndStore(facts, reteEvaluator, tuple.getFactHandle(), fhLookup);
            return tuple;
        }

        public void resolveAndStore(Object[] facts, ValueResolver reteEvaluator, FactHandle factHandle, FactHandleLookup fhLookup) {
            FactHandle fh = LambdaConsequence.getOriginalFactHandle(factHandle);
            if (this.useDrools) {
                fhLookup.put(fh.getObject(), fh);
            }
            facts[this.supplierIndex] = this.declaration.getValue(reteEvaluator, fh);
        }

        @Override
        public int compareTo(TupleFactSupplier o) {
            return o.declarationTupleIndex - this.declarationTupleIndex;
        }
    }

    private static class GlobalSupplier
    implements Comparable<GlobalSupplier> {
        private final int supplierIndex;
        private final String globalName;

        private GlobalSupplier(int supplierIndex, String globalName) {
            this.supplierIndex = supplierIndex;
            this.globalName = globalName;
        }

        public void resolveAndStore(Object[] facts, ReteEvaluator reteEvaluator) {
            facts[this.supplierIndex] = reteEvaluator.getGlobal(this.globalName);
        }

        @Override
        public int compareTo(GlobalSupplier o) {
            return this.globalName.compareTo(o.globalName);
        }
    }
}

