/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.drools.core.util.ClassUtils;
import org.drools.javaparser.ast.drlx.OOPathChunk;
import org.drools.javaparser.ast.drlx.OOPathExpr;
import org.drools.javaparser.ast.expr.BooleanLiteralExpr;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.expr.MethodCallExpr;
import org.drools.javaparser.ast.expr.NameExpr;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.errors.InvalidExpressionErrorResult;
import org.drools.modelcompiler.builder.generator.DeclarationSpec;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.TypedExpression;
import org.drools.modelcompiler.builder.generator.drlxparse.ConstraintParser;
import org.drools.modelcompiler.builder.generator.drlxparse.DrlxParseResult;
import org.drools.modelcompiler.builder.generator.drlxparse.DrlxParseSuccess;
import org.drools.modelcompiler.builder.generator.expression.AbstractExpressionBuilder;
import org.kie.internal.builder.KnowledgeBuilderResult;

public class OOPathExprGenerator {
    private final RuleContext context;
    private final PackageModel packageModel;
    private final AbstractExpressionBuilder expressionBuilder;

    public OOPathExprGenerator(RuleContext context, PackageModel packageModel) {
        this.context = context;
        this.packageModel = packageModel;
        this.expressionBuilder = AbstractExpressionBuilder.getExpressionBuilder(context);
    }

    public void visit(Class<?> originalClass, String originalBind, DrlxParseSuccess patternParseResult) {
        OOPathExpr ooPathExpr = (OOPathExpr)patternParseResult.getExpr();
        Class<Object> previousClass = originalClass;
        String previousBind = originalBind;
        LinkedHashMap<String, List> ooPathConditionExpressions = new LinkedHashMap<String, List>();
        Iterator iterator = ooPathExpr.getChunks().iterator();
        while (iterator.hasNext()) {
            String bindingId;
            Class<Object> fieldType;
            OOPathChunk chunk = (OOPathChunk)iterator.next();
            String fieldName = chunk.getField().toString();
            TypedExpression callExpr = DrlxParseUtil.nameExprToMethodCallExpr(fieldName, previousClass, null);
            if (callExpr == null) {
                this.context.addCompilationError((KnowledgeBuilderResult)new InvalidExpressionErrorResult("Unknown field " + fieldName + " on " + previousClass));
                break;
            }
            Class<Object> clazz = fieldType = chunk.getInlineCast() != null ? DrlxParseUtil.getClassFromContext(this.context.getTypeResolver(), chunk.getInlineCast().toString()) : callExpr.getRawClass();
            if (Iterable.class.isAssignableFrom(fieldType)) {
                fieldType = ClassUtils.extractGenericType(previousClass, (String)((MethodCallExpr)callExpr.getExpression()).getName().toString());
            }
            String chunkKey = originalBind + fieldName;
            if (!iterator.hasNext() && patternParseResult.getExprBinding() != null) {
                bindingId = patternParseResult.getExprBinding();
                this.context.removeDeclarationById(bindingId);
            } else {
                bindingId = this.context.getOOPathId(fieldType, chunkKey);
            }
            Expression accessorLambda = DrlxParseUtil.generateLambdaWithoutParameters(Collections.emptySortedSet(), DrlxParseUtil.prepend((Expression)new NameExpr("_this"), callExpr.getExpression()));
            MethodCallExpr reactiveFrom = new MethodCallExpr(null, "D.reactiveFrom");
            reactiveFrom.addArgument(this.context.getVarExpr(previousBind));
            reactiveFrom.addArgument(accessorLambda);
            DeclarationSpec newDeclaration = this.context.addDeclaration(bindingId, fieldType, (Expression)reactiveFrom);
            this.context.addOOPathDeclaration(newDeclaration);
            List conditions = chunk.getConditions();
            if (!conditions.isEmpty()) {
                Class<Object> finalFieldType = fieldType;
                List conditionParseResult = conditions.stream().map(c -> new ConstraintParser(this.context, this.packageModel).drlxParse(finalFieldType, bindingId, c.toString())).collect(Collectors.toList());
                ooPathConditionExpressions.put(bindingId, conditionParseResult);
            } else if (this.context.isPatternDSL()) {
                ooPathConditionExpressions.put(bindingId, Collections.emptyList());
            } else {
                DrlxParseSuccess drlxParseResult = new DrlxParseSuccess(fieldType, "", bindingId, (Expression)new BooleanLiteralExpr(true), fieldType);
                ooPathConditionExpressions.put(bindingId, Collections.singletonList(drlxParseResult));
            }
            previousBind = bindingId;
            previousClass = fieldType;
        }
        ooPathConditionExpressions.forEach(this.context.isPatternDSL() ? this::toPatternExpr : this::toFlowExpr);
    }

    private void toPatternExpr(String bindingId, List<DrlxParseResult> list) {
        MethodCallExpr patternExpr = new MethodCallExpr(null, "D.pattern");
        patternExpr.addArgument(this.context.getVar(bindingId));
        for (DrlxParseResult drlx : list) {
            if (!drlx.isSuccess()) continue;
            MethodCallExpr expr = (MethodCallExpr)this.expressionBuilder.buildExpressionWithIndexing((DrlxParseSuccess)drlx);
            expr.setScope((Expression)patternExpr);
            patternExpr = expr;
        }
        this.context.addExpression((Expression)patternExpr);
    }

    private void toFlowExpr(String bindingId, List<DrlxParseResult> list) {
        List<DrlxParseSuccess> value = list.stream().filter(DrlxParseResult::isSuccess).map(DrlxParseSuccess.class::cast).collect(Collectors.toList());
        if (value.size() == 1) {
            this.context.addExpression(this.expressionBuilder.buildExpressionWithIndexing((DrlxParseSuccess)value.get(0)));
        } else {
            MethodCallExpr andDSL = new MethodCallExpr(null, "D.and");
            value.forEach(e -> {
                Expression expression = this.expressionBuilder.buildExpressionWithIndexing((DrlxParseSuccess)e);
                andDSL.addArgument(expression);
            });
            this.context.addExpression((Expression)andDSL);
        }
    }
}

