/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.StringUtils;
import org.drools.javaparser.JavaParser;
import org.drools.javaparser.ParseProblemException;
import org.drools.javaparser.ast.Modifier;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.body.Parameter;
import org.drools.javaparser.ast.expr.AssignExpr;
import org.drools.javaparser.ast.expr.CastExpr;
import org.drools.javaparser.ast.expr.ClassExpr;
import org.drools.javaparser.ast.expr.EnclosedExpr;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.expr.LambdaExpr;
import org.drools.javaparser.ast.expr.MethodCallExpr;
import org.drools.javaparser.ast.expr.NameExpr;
import org.drools.javaparser.ast.expr.ObjectCreationExpr;
import org.drools.javaparser.ast.expr.SimpleName;
import org.drools.javaparser.ast.expr.StringLiteralExpr;
import org.drools.javaparser.ast.expr.VariableDeclarationExpr;
import org.drools.javaparser.ast.nodeTypes.NodeWithSimpleName;
import org.drools.javaparser.ast.stmt.BlockStmt;
import org.drools.javaparser.ast.stmt.EmptyStmt;
import org.drools.javaparser.ast.stmt.Statement;
import org.drools.javaparser.ast.type.Type;
import org.drools.javaparser.ast.type.UnknownType;
import org.drools.model.BitMask;
import org.drools.model.bitmask.AllSetButLastBitMask;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.errors.InvalidExpressionErrorResult;
import org.drools.modelcompiler.builder.generator.DeclarationSpec;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.consequence.DroolsImpl;
import org.kie.internal.builder.KnowledgeBuilderResult;

public class Consequence {
    public static final Set<String> knowledgeHelperMethods = new HashSet<String>();
    public static final Set<String> implicitDroolsMethods = new HashSet<String>();
    private static final Expression asKnoledgeHelperExpression = JavaParser.parseExpression((String)("((" + DroolsImpl.class.getCanonicalName() + ") drools).asKnowledgeHelper()"));
    private final RuleContext context;
    private final PackageModel packageModel;

    public Consequence(RuleContext context) {
        this.context = context;
        this.packageModel = context.getPackageModel();
    }

    public MethodCallExpr createCall(RuleDescr ruleDescr, String consequenceString, BlockStmt ruleVariablesBlock, boolean isBreaking) {
        BlockStmt ruleConsequence = null;
        if (this.context.getRuleDialect() == RuleContext.RuleDialect.JAVA) {
            ruleConsequence = this.rewriteConsequence(consequenceString);
            if (ruleConsequence != null) {
                ruleConsequence.findAll(Expression.class).stream().filter(s -> DrlxParseUtil.isNameExprWithName((Node)s, "kcontext")).forEach(n -> n.replace((Node)new CastExpr((Type)DrlxParseUtil.toClassOrInterfaceType(org.kie.api.runtime.rule.RuleContext.class), (Expression)new NameExpr("drools"))));
            } else {
                return null;
            }
        }
        Set<String> usedDeclarationInRHS = this.extractUsedDeclarations(ruleConsequence, consequenceString);
        HashSet<String> usedUnusableDeclarations = new HashSet<String>(this.context.getUnusableOrBinding());
        usedUnusableDeclarations.retainAll(usedDeclarationInRHS);
        for (String s2 : usedUnusableDeclarations) {
            this.context.addCompilationError((KnowledgeBuilderResult)new InvalidExpressionErrorResult(String.format("%s cannot be resolved to a variable", s2)));
        }
        MethodCallExpr onCall = this.onCall(usedDeclarationInRHS);
        if (isBreaking) {
            onCall = new MethodCallExpr((Expression)onCall, "breaking");
        }
        MethodCallExpr executeCall = null;
        if (this.context.getRuleDialect() == RuleContext.RuleDialect.JAVA) {
            executeCall = this.executeCall(ruleVariablesBlock, ruleConsequence, usedDeclarationInRHS, onCall);
        } else if (this.context.getRuleDialect() == RuleContext.RuleDialect.MVEL) {
            executeCall = this.executeScriptCall(ruleDescr, onCall);
        }
        return executeCall;
    }

    private BlockStmt rewriteConsequence(String consequence) {
        String ruleConsequenceAsBlock = this.rewriteConsequenceBlock(consequence.trim());
        try {
            return DrlxParseUtil.parseBlock(ruleConsequenceAsBlock);
        }
        catch (ParseProblemException e) {
            this.context.addCompilationError((KnowledgeBuilderResult)new InvalidExpressionErrorResult("Unable to parse consequence caused by: " + e.getMessage()));
            return null;
        }
    }

    private Set<String> extractUsedDeclarations(BlockStmt ruleConsequence, String consequenceString) {
        HashSet<String> existingDecls = new HashSet<String>();
        existingDecls.addAll(this.context.getAvailableBindings());
        existingDecls.addAll(this.packageModel.getGlobals().keySet());
        if (this.context.getRuleUnitDescr() != null) {
            existingDecls.addAll(this.context.getRuleUnitDescr().getUnitVars());
        }
        if (this.context.getRuleDialect() == RuleContext.RuleDialect.MVEL) {
            return existingDecls.stream().filter(d -> Consequence.containsWord(d, consequenceString)).collect(Collectors.toSet());
        }
        Set declUsedInRHS = ruleConsequence.findAll(NameExpr.class).stream().map(NodeWithSimpleName::getNameAsString).collect(Collectors.toSet());
        return existingDecls.stream().filter(declUsedInRHS::contains).collect(Collectors.toSet());
    }

    public static boolean containsWord(String word, String body) {
        String withoutSpecialCharacters = word.replace("$", "");
        Pattern p = Pattern.compile("\\b" + withoutSpecialCharacters + "\\b");
        Matcher m = p.matcher(body);
        return m.find();
    }

    private MethodCallExpr executeCall(BlockStmt ruleVariablesBlock, BlockStmt ruleConsequence, Collection<String> verifiedDeclUsedInRHS, MethodCallExpr onCall) {
        boolean requireDrools = this.rewriteRHS(ruleVariablesBlock, ruleConsequence);
        MethodCallExpr executeCall = new MethodCallExpr((Expression)onCall, onCall == null ? "D.execute" : "execute");
        LambdaExpr executeLambda = new LambdaExpr();
        executeCall.addArgument((Expression)executeLambda);
        executeLambda.setEnclosingParameters(true);
        if (requireDrools) {
            executeLambda.addParameter(new Parameter((Type)new UnknownType(), "drools"));
        }
        verifiedDeclUsedInRHS.stream().map(x -> new Parameter((Type)new UnknownType(), x)).forEach(arg_0 -> ((LambdaExpr)executeLambda).addParameter(arg_0));
        executeLambda.setBody((Statement)ruleConsequence);
        return executeCall;
    }

    private MethodCallExpr executeScriptCall(RuleDescr ruleDescr, MethodCallExpr onCall) {
        MethodCallExpr executeCall = new MethodCallExpr((Expression)onCall, onCall == null ? "D.executeScript" : "executeScript");
        executeCall.addArgument((Expression)new StringLiteralExpr("mvel"));
        executeCall.addArgument(this.packageModel.getName() + "." + this.packageModel.getRulesFileName() + ".class");
        ObjectCreationExpr objectCreationExpr = new ObjectCreationExpr();
        objectCreationExpr.setType(StringBuilder.class.getCanonicalName());
        ObjectCreationExpr mvelSB = objectCreationExpr;
        for (String i : this.packageModel.getImports()) {
            if (i.equals(this.packageModel.getName() + ".*")) continue;
            mvelSB = this.appendImport((Expression)mvelSB, i);
        }
        StringLiteralExpr mvelScriptBodyStringLiteral = new StringLiteralExpr();
        mvelScriptBodyStringLiteral.setString(ruleDescr.getConsequence().toString());
        MethodCallExpr appendCall = new MethodCallExpr((Expression)mvelSB, "append");
        appendCall.addArgument((Expression)mvelScriptBodyStringLiteral);
        executeCall.addArgument((Expression)new MethodCallExpr((Expression)appendCall, "toString"));
        return executeCall;
    }

    private MethodCallExpr appendImport(Expression mvelSB, String i) {
        MethodCallExpr appendCall = new MethodCallExpr(mvelSB, "append");
        StringLiteralExpr importAsStringLiteral = new StringLiteralExpr();
        importAsStringLiteral.setString("import " + i + ";\n");
        appendCall.addArgument((Expression)importAsStringLiteral);
        return appendCall;
    }

    private MethodCallExpr onCall(Collection<String> usedArguments) {
        MethodCallExpr onCall = null;
        if (!usedArguments.isEmpty()) {
            onCall = new MethodCallExpr(null, "D.on");
            usedArguments.stream().map(this.context::getVar).forEach(arg_0 -> ((MethodCallExpr)onCall).addArgument(arg_0));
        }
        return onCall;
    }

    private String rewriteConsequenceBlock(String consequence) {
        int modifyPos = StringUtils.indexOfOutOfQuotes((String)consequence, (String)"modify");
        if (modifyPos < 0) {
            return consequence;
        }
        int lastCopiedEnd = 0;
        StringBuilder sb = new StringBuilder();
        sb.append(consequence.substring(lastCopiedEnd, modifyPos));
        lastCopiedEnd = modifyPos + 1;
        while (modifyPos >= 0) {
            int declEnd;
            int declStart = consequence.indexOf(40, modifyPos + 6);
            int n = declEnd = declStart > 0 && consequence.indexOf(41, declStart + 1) >= 0 ? StringUtils.findEndOfMethodArgsIndex((CharSequence)consequence, (int)declStart) : -1;
            if (declEnd >= 0) {
                String decl = consequence.substring(declStart + 1, declEnd).trim();
                int blockStart = consequence.indexOf(123, declEnd + 1);
                int blockEnd = consequence.indexOf(125, blockStart + 1);
                if (blockEnd >= 0) {
                    if (lastCopiedEnd < modifyPos) {
                        sb.append(consequence.substring(lastCopiedEnd, modifyPos));
                    }
                    Expression declAsExpr = JavaParser.parseExpression((String)decl);
                    if (decl.indexOf(40) >= 0) {
                        declAsExpr = new EnclosedExpr(declAsExpr);
                    }
                    String originalBlock = consequence.substring(blockStart + 1, blockEnd).trim();
                    BlockStmt modifyBlock = JavaParser.parseBlock((String)("{" + originalBlock + ";}"));
                    List originalMethodCalls = modifyBlock.findAll(MethodCallExpr.class);
                    for (MethodCallExpr mc : originalMethodCalls) {
                        Expression mcWithScope = DrlxParseUtil.prepend(declAsExpr, (Expression)mc);
                        modifyBlock.replace((Node)mc, (Node)mcWithScope);
                    }
                    for (Statement n2 : modifyBlock.getStatements()) {
                        if (n2 instanceof EmptyStmt) continue;
                        sb.append(n2);
                    }
                    sb.append("update(").append(decl).append(");\n");
                    lastCopiedEnd = blockEnd + 1;
                    modifyPos = lastCopiedEnd - 6;
                }
            }
            modifyPos = StringUtils.indexOfOutOfQuotes((String)consequence, (String)"modify", (int)(modifyPos + 6));
        }
        if (lastCopiedEnd < consequence.length()) {
            sb.append(consequence.substring(lastCopiedEnd));
        }
        return sb.toString();
    }

    private boolean rewriteRHS(BlockStmt ruleBlock, BlockStmt rhs) {
        AtomicBoolean requireDrools = new AtomicBoolean(false);
        List methodCallExprs = rhs.findAll(MethodCallExpr.class);
        ArrayList<MethodCallExpr> updateExprs = new ArrayList<MethodCallExpr>();
        for (MethodCallExpr methodCallExpr : methodCallExprs) {
            if (!Consequence.isDroolsMethod(methodCallExpr)) continue;
            if (!methodCallExpr.getScope().isPresent()) {
                methodCallExpr.setScope((Expression)new NameExpr("drools"));
            }
            if (knowledgeHelperMethods.contains(methodCallExpr.getNameAsString())) {
                methodCallExpr.setScope(asKnoledgeHelperExpression);
            } else if (methodCallExpr.getNameAsString().equals("update")) {
                if (methodCallExpr.toString().contains("FactHandle")) {
                    methodCallExpr.setScope((Expression)new NameExpr("((org.drools.modelcompiler.consequence.DroolsImpl) drools)"));
                }
                updateExprs.add(methodCallExpr);
            } else if (methodCallExpr.getNameAsString().equals("retract")) {
                methodCallExpr.setName(new SimpleName("delete"));
            }
            requireDrools.set(true);
        }
        for (MethodCallExpr updateExpr : updateExprs) {
            MethodCallExpr bitMaskCreation;
            Expression argExpr = updateExpr.getArgument(0);
            if (!(argExpr instanceof NameExpr)) continue;
            String updatedVar = ((NameExpr)argExpr).getNameAsString();
            Class updatedClass = this.context.getDeclarationById(updatedVar).map(DeclarationSpec::getDeclarationClass).orElseThrow(RuntimeException::new);
            Set<String> modifiedProps = this.findModifiedProperties(methodCallExprs, updateExpr, updatedVar);
            if (modifiedProps != null) {
                bitMaskCreation = new MethodCallExpr((Expression)new NameExpr(BitMask.class.getCanonicalName()), "getPatternMask");
                bitMaskCreation.addArgument((Expression)new ClassExpr((Type)DrlxParseUtil.toClassOrInterfaceType(updatedClass)));
                modifiedProps.forEach(s -> {
                    MethodCallExpr cfr_ignored_0 = (MethodCallExpr)bitMaskCreation.addArgument((Expression)new StringLiteralExpr(s));
                });
            } else {
                bitMaskCreation = new MethodCallExpr((Expression)new NameExpr(AllSetButLastBitMask.class.getCanonicalName()), "get");
            }
            VariableDeclarationExpr bitMaskVar = new VariableDeclarationExpr((Type)DrlxParseUtil.toClassOrInterfaceType(BitMask.class), "mask_" + updatedVar, new Modifier[]{Modifier.FINAL});
            AssignExpr bitMaskAssign = new AssignExpr((Expression)bitMaskVar, (Expression)bitMaskCreation, AssignExpr.Operator.ASSIGN);
            ruleBlock.addStatement((Expression)bitMaskAssign);
            updateExpr.addArgument("mask_" + updatedVar);
        }
        return requireDrools.get();
    }

    private Set<String> findModifiedProperties(List<MethodCallExpr> methodCallExprs, MethodCallExpr updateExpr, String updatedVar) {
        HashSet<String> modifiedProps = new HashSet<String>();
        for (MethodCallExpr methodCall : methodCallExprs.subList(0, methodCallExprs.indexOf(updateExpr))) {
            if (!methodCall.getScope().isPresent() || !DrlxParseUtil.hasScope(methodCall, updatedVar)) continue;
            String propName = this.methodToProperty(methodCall);
            if (propName != null) {
                modifiedProps.add(propName);
                continue;
            }
            return null;
        }
        return modifiedProps;
    }

    private String methodToProperty(MethodCallExpr mce) {
        String propertyName = ClassUtils.setter2property((String)mce.getNameAsString());
        if (propertyName == null && mce.getArguments().isEmpty()) {
            propertyName = ClassUtils.getter2property((String)mce.getNameAsString());
        }
        return propertyName;
    }

    private static boolean isDroolsMethod(MethodCallExpr mce) {
        boolean hasDroolsScope = DrlxParseUtil.hasScope(mce, "drools");
        boolean isImplicitDroolsMethod = !mce.getScope().isPresent() && implicitDroolsMethods.contains(mce.getNameAsString());
        boolean hasDroolsAsParameter = DrlxParseUtil.findAllChildrenRecursive((Expression)mce).stream().anyMatch(a -> DrlxParseUtil.isNameExprWithName(a, "drools"));
        return hasDroolsScope || isImplicitDroolsMethod || hasDroolsAsParameter;
    }

    static {
        implicitDroolsMethods.add("insert");
        implicitDroolsMethods.add("insertLogical");
        implicitDroolsMethods.add("delete");
        implicitDroolsMethods.add("retract");
        implicitDroolsMethods.add("update");
        knowledgeHelperMethods.add("getWorkingMemory");
        knowledgeHelperMethods.add("getRule");
        knowledgeHelperMethods.add("getTuple");
        knowledgeHelperMethods.add("getKnowledgeRuntime");
        knowledgeHelperMethods.add("getKieRuntime");
        knowledgeHelperMethods.add("insertLogical");
        knowledgeHelperMethods.add("run");
        knowledgeHelperMethods.add("guard");
    }
}

