/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.consequence;

import org.drools.core.WorkingMemory;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.spi.Tuple;
import org.drools.core.util.bitmask.AllSetBitMask;
import org.drools.core.util.bitmask.AllSetButLastBitMask;
import org.drools.core.util.bitmask.EmptyBitMask;
import org.drools.core.util.bitmask.OpenBitSet;
import org.drools.model.BitMask;
import org.drools.model.Consequence;
import org.drools.model.Variable;
import org.drools.model.bitmask.EmptyButLastBitMask;
import org.drools.model.bitmask.LongBitMask;
import org.drools.modelcompiler.RuleContext;
import org.drools.modelcompiler.consequence.DroolsImpl;

public class LambdaConsequence
implements org.drools.core.spi.Consequence {
    private final Consequence consequence;
    private final RuleContext context;

    public LambdaConsequence(Consequence consequence, RuleContext context) {
        this.consequence = consequence;
        this.context = context;
    }

    public String getName() {
        return "default";
    }

    public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) throws Exception {
        Object[] facts;
        Tuple tuple = knowledgeHelper.getTuple();
        Declaration[] declarations = ((RuleTerminalNode)knowledgeHelper.getMatch().getTuple().getTupleSink()).getRequiredDeclarations();
        Variable[] vars = this.consequence.getVariables();
        int factsOffset = 0;
        if (this.consequence.isUsingDrools()) {
            ++factsOffset;
            facts = new Object[vars.length + 1];
            facts[0] = new DroolsImpl(knowledgeHelper, workingMemory);
        } else {
            facts = new Object[vars.length];
        }
        int declrCounter = 0;
        for (Variable var : vars) {
            if (var.isFact()) {
                Declaration declaration = declarations[declrCounter++];
                InternalFactHandle fh = tuple.get(declaration);
                if (this.consequence.isUsingDrools()) {
                    ((DroolsImpl)facts[0]).registerFactHandle(fh);
                }
                facts[factsOffset++] = declaration.getValue((InternalWorkingMemory)workingMemory, fh.getObject());
                continue;
            }
            facts[factsOffset++] = workingMemory.getGlobal(var.getName());
        }
        this.consequence.getBlock().execute(facts);
    }

    static org.drools.core.util.bitmask.BitMask adaptBitMask(BitMask mask) {
        if (mask instanceof LongBitMask) {
            return new org.drools.core.util.bitmask.LongBitMask(((LongBitMask)mask).asLong());
        }
        if (mask instanceof org.drools.model.bitmask.EmptyBitMask) {
            return EmptyBitMask.get();
        }
        if (mask instanceof org.drools.model.bitmask.AllSetBitMask) {
            return AllSetBitMask.get();
        }
        if (mask instanceof org.drools.model.bitmask.AllSetButLastBitMask) {
            return AllSetButLastBitMask.get();
        }
        if (mask instanceof EmptyButLastBitMask) {
            return org.drools.core.util.bitmask.EmptyButLastBitMask.get();
        }
        if (mask instanceof org.drools.model.bitmask.OpenBitSet) {
            return new OpenBitSet(((org.drools.model.bitmask.OpenBitSet)mask).getBits(), ((org.drools.model.bitmask.OpenBitSet)mask).getNumWords());
        }
        throw new IllegalArgumentException("Unknown bitmask: " + mask);
    }
}

