/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.operatorspec;

import java.util.Optional;
import org.drools.javaparser.ast.drlx.expr.PointFreeExpr;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.expr.MethodCallExpr;
import org.drools.javaparser.ast.expr.StringLiteralExpr;
import org.drools.javaparser.ast.expr.UnaryExpr;
import org.drools.model.functions.Operator;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.TypedExpression;
import org.drools.modelcompiler.builder.generator.drlxparse.CoercedExpression;
import org.drools.modelcompiler.builder.generator.expressiontyper.ExpressionTyper;
import org.drools.modelcompiler.builder.generator.operatorspec.OperatorSpec;

public class CustomOperatorSpec
implements OperatorSpec {
    public static final CustomOperatorSpec INSTANCE = new CustomOperatorSpec();

    @Override
    public Expression getExpression(RuleContext context, PointFreeExpr pointFreeExpr, TypedExpression left, ExpressionTyper expressionTyper) {
        MethodCallExpr methodCallExpr = new MethodCallExpr(null, "D.eval");
        String opName = pointFreeExpr.getOperator().asString();
        Operator operator = Operator.Register.getOperator((String)opName);
        try {
            operator.getClass().getField("INSTANCE");
            methodCallExpr.addArgument(operator.getClass().getCanonicalName() + ".INSTANCE");
        }
        catch (NoSuchFieldException e) {
            methodCallExpr.addArgument((Expression)new StringLiteralExpr(opName));
        }
        methodCallExpr.addArgument(left.getExpression());
        for (Expression rightExpr : pointFreeExpr.getRight()) {
            Optional<TypedExpression> optionalRight = expressionTyper.toTypedExpression(rightExpr).getTypedExpression();
            optionalRight.ifPresent(right -> {
                TypedExpression coercedRight;
                if (operator.requiresCoercion()) {
                    CoercedExpression.CoercedExpressionResult coerce = new CoercedExpression(left, (TypedExpression)right).coerce();
                    coercedRight = coerce.getCoercedRight();
                } else {
                    coercedRight = right;
                }
                methodCallExpr.addArgument(coercedRight.getExpression());
            });
        }
        return pointFreeExpr.isNegated() ? new UnaryExpr((Expression)methodCallExpr, UnaryExpr.Operator.LOGICAL_COMPLEMENT) : methodCallExpr;
    }

    @Override
    public boolean isStatic() {
        return false;
    }
}

