/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.drools.compiler.lang.descr.BehaviorDescr;
import org.drools.compiler.lang.descr.EntryPointDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.core.base.ClassObjectType;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.PatternExtractor;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.type.Type;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;

public class DeclarationSpec {
    private final String bindingId;
    private final Class<?> declarationClass;
    private final Optional<PatternDescr> optPattern;
    private final Optional<Expression> declarationSource;
    private final Optional<String> variableName;

    public DeclarationSpec(String bindingId, Class<?> declarationClass) {
        this(bindingId, declarationClass, Optional.empty(), Optional.empty(), Optional.empty());
    }

    DeclarationSpec(String bindingId, Class<?> declarationClass, String variableName) {
        this(bindingId, declarationClass, Optional.empty(), Optional.empty(), Optional.of(variableName));
    }

    DeclarationSpec(String bindingId, Class<?> declarationClass, Expression declarationSource) {
        this(bindingId, declarationClass, Optional.empty(), Optional.of(declarationSource), Optional.empty());
    }

    DeclarationSpec(String bindingId, Class<?> declarationClass, Optional<PatternDescr> pattern, Optional<Expression> declarationSource, Optional<String> variableName) {
        this.bindingId = bindingId;
        this.declarationClass = declarationClass;
        this.optPattern = pattern;
        this.declarationSource = declarationSource;
        this.variableName = variableName;
    }

    Optional<String> getEntryPoint() {
        return this.optPattern.flatMap(pattern -> pattern.getSource() instanceof EntryPointDescr ? Optional.of(((EntryPointDescr)pattern.getSource()).getEntryId()) : Optional.empty());
    }

    public List<BehaviorDescr> getBehaviors() {
        return this.optPattern.map(PatternDescr::getBehaviors).orElse(Collections.emptyList());
    }

    public String getBindingId() {
        return this.bindingId;
    }

    public Class<?> getDeclarationClass() {
        return this.declarationClass;
    }

    public Optional<PatternDescr> getOptPattern() {
        return this.optPattern;
    }

    public Optional<Expression> getDeclarationSource() {
        return this.declarationSource;
    }

    public Optional<String> getVariableName() {
        return this.variableName;
    }

    public Type getType() {
        return DrlxParseUtil.classToReferenceType(this.getDeclarationClass());
    }

    public String toString() {
        return "DeclarationSpec{bindingId='" + this.bindingId + '\'' + ", declarationClass=" + this.declarationClass + '}';
    }

    public Declaration asDeclaration() {
        Declaration decl = new Declaration(this.bindingId, (InternalReadAccessor)new PatternExtractor((ObjectType)new ClassObjectType(this.declarationClass)), null);
        decl.setDeclarationClass(this.declarationClass);
        return decl;
    }
}

