/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.util;

import java.util.Map;
import org.drools.core.base.evaluators.TimeIntervalParser;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.model.AnnotationValue;
import org.drools.model.TypeMetaData;
import org.drools.modelcompiler.constraints.MvelReadAccessor;
import org.kie.api.definition.type.Duration;
import org.kie.api.definition.type.Expires;
import org.kie.api.definition.type.Role;
import org.kie.api.definition.type.Timestamp;

public class TypeDeclarationUtil {
    public static TypeDeclaration createTypeDeclaration(KnowledgePackageImpl pkg, TypeMetaData metaType) {
        try {
            Class typeClass = pkg.getTypeResolver().resolveType(metaType.getPackage() + "." + metaType.getName());
            TypeDeclaration typeDeclaration = TypeDeclaration.createTypeDeclarationForBean((Class)typeClass);
            block14: for (Map.Entry ann : metaType.getAnnotations().entrySet()) {
                switch ((String)ann.getKey()) {
                    case "role": {
                        for (AnnotationValue annVal : (AnnotationValue[])ann.getValue()) {
                            if (!annVal.getKey().equals("value") || !annVal.getValue().equals("event")) continue;
                            typeDeclaration.setRole(Role.Type.EVENT);
                        }
                        continue block14;
                    }
                    case "duration": {
                        for (AnnotationValue annVal : (AnnotationValue[])ann.getValue()) {
                            if (!annVal.getKey().equals("value")) continue;
                            TypeDeclarationUtil.wireDurationAccessor(annVal.getValue().toString(), typeDeclaration, (InternalKnowledgePackage)pkg);
                        }
                        continue block14;
                    }
                    case "timestamp": {
                        for (AnnotationValue annVal : (AnnotationValue[])ann.getValue()) {
                            if (!annVal.getKey().equals("value")) continue;
                            TypeDeclarationUtil.wireTimestampAccessor(annVal.getValue().toString(), typeDeclaration, (InternalKnowledgePackage)pkg);
                        }
                        continue block14;
                    }
                    case "expires": {
                        for (AnnotationValue annVal : (AnnotationValue[])ann.getValue()) {
                            if (annVal.getKey().equals("value")) {
                                long offset = TimeIntervalParser.parseSingle((String)annVal.getValue().toString());
                                typeDeclaration.setExpirationOffset(offset == -1L ? Long.MAX_VALUE : offset);
                                continue;
                            }
                            if (!annVal.getKey().equals("policy")) continue;
                            typeDeclaration.setExpirationType(Enum.valueOf(Expires.Policy.class, annVal.getValue().toString()));
                        }
                        continue block14;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown annotation: " + (String)ann.getKey());
                    }
                }
            }
            return typeDeclaration;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static TypeDeclaration createTypeDeclaration(InternalKnowledgePackage pkg, Class<?> cls) {
        Timestamp timestamp;
        TypeDeclaration typeDeclaration = TypeDeclaration.createTypeDeclarationForBean(cls);
        Duration duration = cls.getAnnotation(Duration.class);
        if (duration != null) {
            TypeDeclarationUtil.wireDurationAccessor(duration.value(), typeDeclaration, pkg);
        }
        if ((timestamp = cls.getAnnotation(Timestamp.class)) != null) {
            TypeDeclarationUtil.wireDurationAccessor(timestamp.value(), typeDeclaration, pkg);
        }
        return typeDeclaration;
    }

    private static void wireDurationAccessor(String durationField, TypeDeclaration type, InternalKnowledgePackage pkg) {
        type.setDurationAttribute(durationField);
        type.setDurationExtractor(TypeDeclarationUtil.getFieldExtractor(type, durationField, pkg, Long.TYPE));
    }

    private static void wireTimestampAccessor(String timestampField, TypeDeclaration type, InternalKnowledgePackage pkg) {
        type.setTimestampAttribute(timestampField);
        type.setTimestampExtractor(TypeDeclarationUtil.getFieldExtractor(type, timestampField, pkg, Long.TYPE));
    }

    private static InternalReadAccessor getFieldExtractor(TypeDeclaration type, String field, InternalKnowledgePackage pkg, Class<?> returnType) {
        return new MvelReadAccessor(type.getTypeClass(), returnType, field);
    }
}

