/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.util;

import java.lang.reflect.Method;

public class ClassUtil {
    public static Method findMethod(Class<?> clazz, String methodName, Class[] argsType) {
        try {
            return clazz.getMethod(methodName, argsType);
        }
        catch (NoSuchMethodException e) {
            Method m = ClassUtil.getBestCandidate(clazz, argsType, methodName);
            if (m != null) {
                return m;
            }
            throw new UnsupportedOperationException("Method " + methodName + " on class " + clazz.getName() + " is missing");
        }
    }

    public static Method getBestCandidate(Class clazz, Class[] argsType, String methodName) {
        return ClassUtil.getBestCandidate(clazz, argsType, methodName, clazz.getMethods());
    }

    public static Method getBestCandidate(Class clazz, Class[] argsType, String methodName, Method[] methods) {
        if (methods.length == 0) {
            return null;
        }
        Method bestCandidate = null;
        int bestScore = -1;
        boolean retry = false;
        while (true) {
            int i;
            for (Method meth : methods) {
                int score;
                if (!methodName.equals(meth.getName())) continue;
                Class<?>[] parmTypes = meth.getParameterTypes();
                if (parmTypes.length == 0 && argsType.length == 0) {
                    if (bestCandidate != null && !ClassUtil.isMoreSpecialized(meth, bestCandidate)) continue;
                    bestCandidate = meth;
                    continue;
                }
                boolean isVarArgs = meth.isVarArgs();
                if (ClassUtil.isArgsNumberNotCompatible(argsType, parmTypes, isVarArgs) || (score = ClassUtil.getMethodScore(argsType, parmTypes, isVarArgs)) == 0) continue;
                if (score > bestScore) {
                    bestCandidate = meth;
                    bestScore = score;
                    continue;
                }
                if (score != bestScore || !ClassUtil.isMoreSpecialized(meth, bestCandidate) || isVarArgs) continue;
                bestCandidate = meth;
            }
            if (bestCandidate != null || retry || !clazz.isInterface()) break;
            Method[] objMethods = Object.class.getMethods();
            Method[] nMethods = new Method[methods.length + objMethods.length];
            for (i = 0; i < methods.length; ++i) {
                nMethods[i] = methods[i];
            }
            for (i = 0; i < objMethods.length; ++i) {
                nMethods[i + methods.length] = objMethods[i];
            }
            methods = nMethods;
            retry = true;
        }
        return bestCandidate;
    }

    private static boolean isArgsNumberNotCompatible(Class[] arguments, Class<?>[] parmTypes, boolean isVarArgs) {
        return isVarArgs && parmTypes.length - 1 > arguments.length || !isVarArgs && parmTypes.length != arguments.length;
    }

    private static boolean isMoreSpecialized(Method newCandidate, Method oldCandidate) {
        return oldCandidate.getReturnType().isAssignableFrom(newCandidate.getReturnType()) && oldCandidate.getDeclaringClass().isAssignableFrom(newCandidate.getDeclaringClass());
    }

    private static int getMethodScore(Class[] arguments, Class<?>[] parmTypes, boolean varArgs) {
        int score = 0;
        for (int i = 0; i != arguments.length; ++i) {
            Class<?> actualParamType = varArgs && i >= parmTypes.length - 1 ? parmTypes[parmTypes.length - 1].getComponentType() : parmTypes[i];
            if (arguments[i] == null) {
                if (!actualParamType.isPrimitive()) {
                    score += 6;
                    continue;
                }
                score = 0;
                break;
            }
            if (actualParamType == arguments[i]) {
                score += 7;
                continue;
            }
            if (actualParamType.isPrimitive() && ClassUtil.boxPrimitive(actualParamType) == arguments[i]) {
                score += 6;
                continue;
            }
            if (arguments[i].isPrimitive() && ClassUtil.unboxPrimitive(arguments[i]) == actualParamType) {
                score += 6;
                continue;
            }
            if (actualParamType.isAssignableFrom(arguments[i])) {
                score += 5;
                continue;
            }
            if (ClassUtil.isNumericallyCoercible(arguments[i], actualParamType)) {
                score += 4;
                continue;
            }
            if (ClassUtil.boxPrimitive(actualParamType).isAssignableFrom(ClassUtil.boxPrimitive(arguments[i])) && Object.class != arguments[i]) {
                score += 3 + ClassUtil.scoreInterface(actualParamType, arguments[i]);
                continue;
            }
            if (ClassUtil.canConvert(actualParamType, arguments[i])) {
                if (actualParamType.isArray() && arguments[i].isArray()) {
                    ++score;
                } else if (actualParamType == Character.TYPE && arguments[i] == String.class) {
                    ++score;
                }
                ++score;
                continue;
            }
            if (actualParamType == Object.class || arguments[i] == NullType.class) {
                ++score;
                continue;
            }
            score = 0;
            break;
        }
        if (score == 0 && varArgs && parmTypes.length - 1 == arguments.length) {
            score += 3;
        }
        return score;
    }

    public static boolean canConvert(Class toType, Class convertFrom) {
        return ClassUtil.isAssignableFrom(toType, convertFrom) || toType.isArray() && ClassUtil.canConvert(toType.getComponentType(), convertFrom);
    }

    public static int scoreInterface(Class<?> parm, Class<?> arg) {
        Class<?>[] iface;
        if (parm.isInterface() && (iface = arg.getInterfaces()) != null) {
            for (Class<?> c : iface) {
                if (c == parm) {
                    return 1;
                }
                if (!parm.isAssignableFrom(c)) continue;
                return ClassUtil.scoreInterface(parm, arg.getSuperclass());
            }
        }
        return 0;
    }

    public static boolean isNumericallyCoercible(Class target, Class parm) {
        Class<?> boxedTarget;
        Class<?> clazz = boxedTarget = target.isPrimitive() ? ClassUtil.boxPrimitive(target) : target;
        if (boxedTarget != null && Number.class.isAssignableFrom(target) && (boxedTarget = parm.isPrimitive() ? ClassUtil.boxPrimitive(parm) : parm) != null) {
            return Number.class.isAssignableFrom(boxedTarget);
        }
        return false;
    }

    public static Class<?> boxPrimitive(Class cls) {
        if (cls == Integer.TYPE || cls == Integer.class) {
            return Integer.class;
        }
        if (cls == int[].class || cls == Integer[].class) {
            return Integer[].class;
        }
        if (cls == Character.TYPE || cls == Character.class) {
            return Character.class;
        }
        if (cls == char[].class || cls == Character[].class) {
            return Character[].class;
        }
        if (cls == Long.TYPE || cls == Long.class) {
            return Long.class;
        }
        if (cls == long[].class || cls == Long[].class) {
            return Long[].class;
        }
        if (cls == Short.TYPE || cls == Short.class) {
            return Short.class;
        }
        if (cls == short[].class || cls == Short[].class) {
            return Short[].class;
        }
        if (cls == Double.TYPE || cls == Double.class) {
            return Double.class;
        }
        if (cls == double[].class || cls == Double[].class) {
            return Double[].class;
        }
        if (cls == Float.TYPE || cls == Float.class) {
            return Float.class;
        }
        if (cls == float[].class || cls == Float[].class) {
            return Float[].class;
        }
        if (cls == Boolean.TYPE || cls == Boolean.class) {
            return Boolean.class;
        }
        if (cls == boolean[].class || cls == Boolean[].class) {
            return Boolean[].class;
        }
        if (cls == Byte.TYPE || cls == Byte.class) {
            return Byte.class;
        }
        if (cls == byte[].class || cls == Byte[].class) {
            return Byte[].class;
        }
        return cls;
    }

    public static Class unboxPrimitive(Class cls) {
        if (cls == Integer.class || cls == Integer.TYPE) {
            return Integer.TYPE;
        }
        if (cls == Integer[].class || cls == int[].class) {
            return int[].class;
        }
        if (cls == Long.class || cls == Long.TYPE) {
            return Long.TYPE;
        }
        if (cls == Long[].class || cls == long[].class) {
            return long[].class;
        }
        if (cls == Character.class || cls == Character.TYPE) {
            return Character.TYPE;
        }
        if (cls == Character[].class || cls == char[].class) {
            return char[].class;
        }
        if (cls == Short.class || cls == Short.TYPE) {
            return Short.TYPE;
        }
        if (cls == Short[].class || cls == short[].class) {
            return short[].class;
        }
        if (cls == Double.class || cls == Double.TYPE) {
            return Double.TYPE;
        }
        if (cls == Double[].class || cls == double[].class) {
            return double[].class;
        }
        if (cls == Float.class || cls == Float.TYPE) {
            return Float.TYPE;
        }
        if (cls == Float[].class || cls == float[].class) {
            return float[].class;
        }
        if (cls == Boolean.class || cls == Boolean.TYPE) {
            return Boolean.TYPE;
        }
        if (cls == Boolean[].class || cls == boolean[].class) {
            return boolean[].class;
        }
        if (cls == Byte.class || cls == Byte.TYPE) {
            return Byte.TYPE;
        }
        if (cls == Byte[].class || cls == byte[].class) {
            return byte[].class;
        }
        return cls;
    }

    public static boolean isAssignableFrom(Class<?> from, Class<?> to) {
        return from.isAssignableFrom(to) || ClassUtil.areBoxingCompatible(from, to);
    }

    private static boolean areBoxingCompatible(Class<?> c1, Class<?> c2) {
        return c1.isPrimitive() ? ClassUtil.isPrimitiveOf(c2, c1) : c2.isPrimitive() && ClassUtil.isPrimitiveOf(c1, c2);
    }

    private static boolean isPrimitiveOf(Class<?> boxed, Class<?> primitive) {
        if (primitive == Integer.TYPE) {
            return boxed == Integer.class;
        }
        if (primitive == Long.TYPE) {
            return boxed == Long.class;
        }
        if (primitive == Double.TYPE) {
            return boxed == Double.class;
        }
        if (primitive == Float.TYPE) {
            return boxed == Float.class;
        }
        if (primitive == Short.TYPE) {
            return boxed == Short.class;
        }
        if (primitive == Byte.TYPE) {
            return boxed == Byte.class;
        }
        if (primitive == Character.TYPE) {
            return boxed == Character.class;
        }
        if (primitive == Boolean.TYPE) {
            return boxed == Boolean.class;
        }
        return false;
    }

    public static Class<?> toNonPrimitiveType(Class<?> c) {
        if (!c.isPrimitive()) {
            return c;
        }
        if (c == Integer.TYPE) {
            return Integer.class;
        }
        if (c == Long.TYPE) {
            return Long.class;
        }
        if (c == Double.TYPE) {
            return Double.class;
        }
        if (c == Float.TYPE) {
            return Float.class;
        }
        if (c == Short.TYPE) {
            return Short.class;
        }
        if (c == Byte.TYPE) {
            return Byte.class;
        }
        if (c == Character.TYPE) {
            return Character.class;
        }
        return Boolean.class;
    }

    public static class NullType {
    }
}

