/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.constraints;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.phreak.ReactiveObject;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.DataProvider;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.Tuple;
import org.drools.model.functions.Function1;

public class LambdaDataProvider
implements DataProvider {
    private final Function1 providerFunction;
    private Declaration declaration;
    private final boolean reactive;

    public LambdaDataProvider(Declaration declaration, Function1 providerFunction, boolean reactive) {
        this.declaration = declaration;
        this.providerFunction = providerFunction;
        this.reactive = reactive;
    }

    public Declaration[] getRequiredDeclarations() {
        return new Declaration[]{this.declaration};
    }

    public Object createContext() {
        return null;
    }

    public Iterator getResults(Tuple tuple, InternalWorkingMemory wm, PropagationContext ctx, Object providerContext) {
        Object result;
        Object object = result = this.declaration.getExtractor().isGlobal() ? this.declaration.getExtractor().getValue(wm, (Object)this.declaration.getIdentifier()) : this.declaration.getValue(wm, tuple.get(this.declaration).getObject());
        if (this.providerFunction != null) {
            result = this.providerFunction.apply(result);
        }
        if (this.isReactive()) {
            if (result instanceof ReactiveObject) {
                ((ReactiveObject)result).addLeftTuple(tuple);
            }
            if (result instanceof Iterable) {
                for (Object value : (Iterable)result) {
                    if (!(value instanceof ReactiveObject)) continue;
                    ((ReactiveObject)value).addLeftTuple(tuple);
                }
            }
        }
        if (result instanceof Object[]) {
            return Arrays.asList((Object[])result).iterator();
        }
        if (result instanceof Iterator) {
            return (Iterator)result;
        }
        if (result instanceof Iterable) {
            return ((Iterable)result).iterator();
        }
        return Collections.singletonList(result).iterator();
    }

    public DataProvider clone() {
        return new LambdaDataProvider(this.declaration.clone(), this.providerFunction, this.reactive);
    }

    public void replaceDeclaration(Declaration declaration, Declaration resolved) {
        if (this.declaration.getIdentifier().equals(declaration.getIdentifier())) {
            this.declaration = resolved;
        }
    }

    public boolean isReactive() {
        return this.reactive;
    }
}

