/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.constraints;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.drools.core.WorkingMemory;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.reteoo.SubnetworkTuple;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.Accumulator;
import org.drools.core.spi.Tuple;
import org.drools.model.Binding;
import org.kie.api.runtime.rule.AccumulateFunction;

public abstract class LambdaAccumulator
implements Accumulator {
    private final AccumulateFunction accumulateFunction;
    protected final List<String> sourceVariables;

    protected LambdaAccumulator(AccumulateFunction accumulateFunction, List<String> sourceVariables) {
        this.accumulateFunction = accumulateFunction;
        this.sourceVariables = sourceVariables;
    }

    public static LambdaAccumulator createLambdaAccumulator(AccumulateFunction accumulateFunction, List<String> sourceVariables, Binding binding) {
        return binding == null ? new NotBindingAcc(accumulateFunction, sourceVariables) : new BindingAcc(accumulateFunction, sourceVariables, binding);
    }

    public Object createWorkingMemoryContext() {
        return null;
    }

    public Serializable createContext() {
        try {
            Serializable originalContext = this.accumulateFunction.createContext();
            this.accumulateFunction.init(originalContext);
            return originalContext;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void init(Object workingMemoryContext, Object context, Tuple leftTuple, Declaration[] declarations, WorkingMemory workingMemory) throws Exception {
    }

    public void accumulate(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, Declaration[] declarations, Declaration[] innerDeclarations, WorkingMemory workingMemory) throws Exception {
        Object returnObject = this.getAccumulatedObject(declarations, innerDeclarations, handle.getObject());
        this.accumulateFunction.accumulate((Serializable)context, returnObject);
    }

    protected abstract Object getAccumulatedObject(Declaration[] var1, Declaration[] var2, Object var3);

    public boolean supportsReverse() {
        return this.accumulateFunction.supportsReverse();
    }

    public void reverse(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, Declaration[] declarations, Declaration[] innerDeclarations, WorkingMemory workingMemory) throws Exception {
        this.accumulateFunction.reverse((Serializable)context, handle.getObject());
    }

    public Object getResult(Object workingMemoryContext, Object context, Tuple leftTuple, Declaration[] declarations, WorkingMemory workingMemory) throws Exception {
        return this.accumulateFunction.getResult((Serializable)context);
    }

    public static class NotBindingAcc
    extends LambdaAccumulator {
        public NotBindingAcc(AccumulateFunction accumulateFunction, List<String> sourceVariables) {
            super(accumulateFunction, sourceVariables);
        }

        @Override
        protected Object getAccumulatedObject(Declaration[] declarations, Declaration[] innerDeclarations, Object accumulateObject) {
            if (accumulateObject instanceof SubnetworkTuple) {
                return ((SubnetworkTuple)accumulateObject).getObject(declarations[0]);
            }
            return accumulateObject;
        }
    }

    public static class BindingAcc
    extends LambdaAccumulator {
        private final Binding binding;

        public BindingAcc(AccumulateFunction accumulateFunction, List<String> sourceVariables, Binding binding) {
            super(accumulateFunction, sourceVariables);
            this.binding = binding;
        }

        @Override
        protected Object getAccumulatedObject(Declaration[] declarations, Declaration[] innerDeclarations, Object accumulateObject) {
            if (accumulateObject instanceof SubnetworkTuple) {
                Object[] args = Arrays.stream(innerDeclarations).filter(d -> this.sourceVariables.contains(d.getIdentifier())).map(d -> ((SubnetworkTuple)accumulateObject).getObject(d)).toArray();
                return this.binding.eval(args);
            }
            return this.binding.eval(new Object[]{accumulateObject});
        }
    }
}

