/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.constraints;

import java.util.stream.Stream;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.spi.Tuple;
import org.drools.core.time.Interval;
import org.drools.model.Index;
import org.drools.model.SingleConstraint;
import org.drools.model.functions.PredicateN;

public class ConstraintEvaluator {
    protected final SingleConstraint constraint;
    private final Declaration[] declarations;
    private final Declaration[] requiredDeclarations;
    private final Declaration patternDeclaration;
    private final Pattern pattern;

    public ConstraintEvaluator(Declaration[] declarations, SingleConstraint constraint) {
        this.constraint = constraint;
        this.declarations = declarations;
        this.requiredDeclarations = declarations;
        this.patternDeclaration = null;
        this.pattern = null;
    }

    public ConstraintEvaluator(Pattern pattern, SingleConstraint constraint) {
        this.constraint = constraint;
        this.declarations = new Declaration[]{pattern.getDeclaration()};
        this.patternDeclaration = this.findPatternDeclaration(pattern);
        this.requiredDeclarations = new Declaration[0];
        this.pattern = pattern;
    }

    public ConstraintEvaluator(Declaration[] declarations, Pattern pattern, SingleConstraint constraint) {
        this.constraint = constraint;
        this.declarations = declarations;
        this.pattern = pattern;
        this.patternDeclaration = this.findPatternDeclaration(pattern);
        this.requiredDeclarations = (Declaration[])Stream.of(declarations).filter(d -> !d.getIdentifier().equals(pattern.getDeclaration().getIdentifier())).toArray(Declaration[]::new);
    }

    private Declaration findPatternDeclaration(Pattern pattern) {
        for (Declaration declaration : this.declarations) {
            if (!pattern.getDeclaration().getIdentifier().equals(declaration.getIdentifier())) continue;
            return declaration;
        }
        return null;
    }

    public boolean evaluate(InternalFactHandle handle, InternalWorkingMemory workingMemory) {
        Object[] objectArray;
        PredicateN predicateN = this.constraint.getPredicate();
        if (this.declarations.length == 1) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = handle.getObject();
        } else {
            objectArray = this.getAlphaInvocationArgs(handle, workingMemory);
        }
        return predicateN.test(objectArray);
    }

    public Object[] getAlphaInvocationArgs(InternalFactHandle handle, InternalWorkingMemory workingMemory) {
        Object[] params = new Object[this.declarations.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = this.getArgument(handle, workingMemory, this.declarations[i], null);
        }
        return params;
    }

    private Object getArgument(InternalFactHandle handle, InternalWorkingMemory workingMemory, Declaration declaration, Tuple tuple) {
        return declaration == this.patternDeclaration ? handle.getObject() : declaration.getValue(workingMemory, tuple != null ? tuple.getObject(declaration.getPattern().getOffset()) : null);
    }

    public boolean evaluate(InternalFactHandle handle, Tuple tuple, InternalWorkingMemory workingMemory) {
        return this.constraint.getPredicate().test(this.getBetaInvocationArgs(handle, tuple, workingMemory));
    }

    private Object[] getBetaInvocationArgs(InternalFactHandle handle, Tuple tuple, InternalWorkingMemory workingMemory) {
        Object[] params = new Object[this.declarations.length];
        for (int i = 0; i < this.declarations.length; ++i) {
            params[i] = this.getArgument(handle, workingMemory, this.declarations[i], tuple);
        }
        return params;
    }

    protected InternalFactHandle[] getBetaInvocationFactHandles(InternalFactHandle handle, Tuple tuple) {
        InternalFactHandle[] fhs = new InternalFactHandle[this.declarations.length];
        for (int i = 0; i < fhs.length; ++i) {
            fhs[i] = this.declarations[i] == this.patternDeclaration ? handle : tuple.get(this.declarations[i].getPattern().getOffset());
        }
        return fhs;
    }

    public Index getIndex() {
        return this.constraint.getIndex();
    }

    public String[] getReactiveProps() {
        return this.constraint.getReactiveProps();
    }

    public String toString() {
        return this.constraint.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return this.getId().equals(((ConstraintEvaluator)other).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String getId() {
        return this.constraint.getExprId();
    }

    public Declaration[] getRequiredDeclarations() {
        return this.requiredDeclarations;
    }

    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
        for (int i = 0; i < this.declarations.length; ++i) {
            if (!this.declarations[i].equals((Object)oldDecl)) continue;
            this.declarations[i] = newDecl;
            break;
        }
    }

    public ConstraintEvaluator clone() {
        Declaration[] clonedDeclarations = (Declaration[])Stream.of(this.declarations).map(Declaration::clone).toArray(Declaration[]::new);
        return this.pattern == null ? new ConstraintEvaluator(clonedDeclarations, this.constraint) : new ConstraintEvaluator(clonedDeclarations, this.pattern, this.constraint);
    }

    public boolean isTemporal() {
        return false;
    }

    public Interval getInterval() {
        throw new UnsupportedOperationException();
    }
}

