/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.visitor;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.drools.compiler.lang.descr.AnnotationDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.ExprConstraintDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.compiler.lang.descr.PatternSourceDescr;
import org.drools.javaparser.ast.drlx.OOPathExpr;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.expr.MethodCallExpr;
import org.drools.javaparser.ast.expr.NameExpr;
import org.drools.model.impl.NamesGenerator;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.generator.DeclarationSpec;
import org.drools.modelcompiler.builder.generator.DrlxParseResult;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;
import org.drools.modelcompiler.builder.generator.ModelGenerator;
import org.drools.modelcompiler.builder.generator.OOPathExprGenerator;
import org.drools.modelcompiler.builder.generator.QueryGenerator;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.WindowReferenceGenerator;
import org.drools.modelcompiler.builder.generator.visitor.FromVisitor;
import org.kie.api.definition.type.Position;

public class PatternVisitor {
    static final String INPUT_CALL = "input";
    private final RuleContext context;
    private final PackageModel packageModel;

    public PatternVisitor(RuleContext context, PackageModel packageModel) {
        this.context = context;
        this.packageModel = packageModel;
    }

    public void visit(PatternDescr pattern) {
        String className = pattern.getObjectType();
        List constraintDescrs = pattern.getConstraint().getDescrs();
        if (QueryGenerator.bindQuery(this.context, this.packageModel, pattern, constraintDescrs)) {
            return;
        }
        if (QueryGenerator.createQueryCall(this.packageModel, this.context, pattern)) {
            return;
        }
        Class<?> patternType = DrlxParseUtil.getClassFromContext(this.context.getPkg().getTypeResolver(), className);
        if (pattern.getIdentifier() == null) {
            pattern.setIdentifier(NamesGenerator.generateName((String)("pattern_" + patternType.getSimpleName())));
        }
        Optional<Expression> declarationSource = this.buildFromDeclaration(pattern);
        this.context.addDeclaration(new DeclarationSpec(pattern.getIdentifier(), patternType, Optional.of(pattern), declarationSource));
        if (constraintDescrs.isEmpty() && pattern.getSource() == null) {
            this.context.addExpression((Expression)this.createInputExpression(pattern));
        } else {
            this.buildConstraints(pattern, constraintDescrs, patternType);
        }
    }

    private void buildConstraints(PatternDescr pattern, List<? extends BaseDescr> constraintDescrs, Class<?> patternType) {
        boolean allConstraintsPositional = this.areAllConstraintsPositional(constraintDescrs);
        if (allConstraintsPositional) {
            MethodCallExpr andDSL = new MethodCallExpr(null, "and");
            this.context.addExpression((Expression)andDSL);
            this.context.pushExprPointer(arg_0 -> ((MethodCallExpr)andDSL).addArgument(arg_0));
        }
        for (BaseDescr baseDescr : constraintDescrs) {
            this.buildConstraint(pattern, patternType, baseDescr);
        }
        if (allConstraintsPositional) {
            this.context.popExprPointer();
        }
    }

    private void buildConstraint(PatternDescr pattern, Class<?> patternType, BaseDescr constraint) {
        DrlxParseResult drlxParseResult;
        boolean isPositional = PatternVisitor.isPositional(constraint);
        String expression = PatternVisitor.getConstraintExpression(patternType, constraint, isPositional);
        String patternIdentifier = pattern.getIdentifier();
        if (expression.contains(":=")) {
            expression = expression.replace(":=", "==");
        }
        if ((drlxParseResult = ModelGenerator.drlxParse(this.context, this.packageModel, patternType, patternIdentifier, expression, isPositional)) != null) {
            if (drlxParseResult.getExpr() instanceof OOPathExpr) {
                if (patternIdentifier == null) {
                    patternIdentifier = this.context.getExprId(patternType, expression);
                    this.context.addDeclaration(new DeclarationSpec(patternIdentifier, patternType, Optional.of(pattern), Optional.empty()));
                }
                this.context.addExpression((Expression)this.createInputExpression(pattern));
                new OOPathExprGenerator(this.context, this.packageModel).visit(patternType, patternIdentifier, (OOPathExpr)drlxParseResult.getExpr());
            } else {
                Collection lookAheadFieldsOfIdentifier = this.context.getRuleDescr().lookAheadFieldsOfIdentifier(pattern);
                drlxParseResult.getReactOnProperties().addAll(lookAheadFieldsOfIdentifier);
                drlxParseResult.setWatchedProperties(PatternVisitor.getPatternListenedProperties(pattern));
                if (pattern.isUnification()) {
                    drlxParseResult.setPatternBindingUnification(true);
                }
                ModelGenerator.processExpression(this.context, drlxParseResult);
            }
        }
    }

    private boolean areAllConstraintsPositional(List<? extends BaseDescr> constraintDescrs) {
        return !constraintDescrs.isEmpty() && constraintDescrs.stream().allMatch(c -> c instanceof ExprConstraintDescr && ((ExprConstraintDescr)c).getType().equals((Object)ExprConstraintDescr.Type.POSITIONAL));
    }

    private Optional<Expression> buildFromDeclaration(PatternDescr pattern) {
        Optional<PatternSourceDescr> source = Optional.ofNullable(pattern.getSource());
        Optional<Expression> declarationSourceFrom = source.flatMap(new FromVisitor(this.context, this.packageModel)::visit);
        Optional declarationSourceWindow = source.flatMap(new WindowReferenceGenerator(this.packageModel, this.context.getPkg())::visit);
        return declarationSourceFrom.isPresent() ? declarationSourceFrom : declarationSourceWindow;
    }

    private MethodCallExpr createInputExpression(PatternDescr pattern) {
        MethodCallExpr dslExpr = new MethodCallExpr(null, INPUT_CALL);
        dslExpr.addArgument((Expression)new NameExpr(DrlxParseUtil.toVar(pattern.getIdentifier())));
        return dslExpr;
    }

    private static String getConstraintExpression(Class<?> patternType, BaseDescr constraint, boolean isPositional) {
        if (isPositional) {
            int position = ((ExprConstraintDescr)constraint).getPosition();
            return PatternVisitor.getFieldAtPosition(patternType, position) + " == " + constraint.toString();
        }
        return constraint.toString();
    }

    private static boolean isPositional(BaseDescr constraint) {
        return constraint instanceof ExprConstraintDescr && ((ExprConstraintDescr)constraint).getType() == ExprConstraintDescr.Type.POSITIONAL;
    }

    private static String getFieldAtPosition(Class<?> patternType, int position) {
        for (Field field : patternType.getDeclaredFields()) {
            Position p = field.getAnnotation(Position.class);
            if (p == null || p.value() != position) continue;
            return field.getName();
        }
        throw new RuntimeException("Cannot find field in position " + position + " for " + patternType);
    }

    private static String[] getPatternListenedProperties(PatternDescr pattern) {
        AnnotationDescr watchAnn = pattern != null ? pattern.getAnnotation("watch") : null;
        return watchAnn == null ? new String[]{} : watchAnn.getValue().toString().split(",");
    }
}

