/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.visitor;

import java.util.Collections;
import java.util.Iterator;
import org.drools.compiler.lang.descr.AndDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.ConditionalBranchDescr;
import org.drools.compiler.lang.descr.NamedConsequenceDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.expr.MethodCallExpr;
import org.drools.javaparser.ast.expr.NameExpr;
import org.drools.javaparser.ast.expr.StringLiteralExpr;
import org.drools.javaparser.ast.stmt.BlockStmt;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.generator.DrlxParseResult;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;
import org.drools.modelcompiler.builder.generator.ModelGenerator;
import org.drools.modelcompiler.builder.generator.RuleContext;

public class NamedConsequenceVisitor {
    public static final String WHEN_CALL = "when";
    public static final String ELSE_WHEN_CALL = "elseWhen";
    public static final String THEN_CALL = "then";
    public static final String BREAKING_CALL = "breaking";
    final RuleContext context;
    final PackageModel packageModel;

    public NamedConsequenceVisitor(RuleContext context, PackageModel packageModel) {
        this.context = context;
        this.packageModel = packageModel;
    }

    public void visit(NamedConsequenceDescr descr) {
        MethodCallExpr executeCallDSL = this.onDSL(descr);
        this.context.addExpression((Expression)executeCallDSL);
    }

    public void visit(ConditionalBranchDescr desc) {
        PatternDescr patternRelated = (PatternDescr)this.getReferringPatternDescr(desc, (AndDescr)this.context.parentDesc);
        Class<?> patternRelatedClass = DrlxParseUtil.getClassFromContext(this.context.getPkg().getTypeResolver(), patternRelated.getObjectType());
        MethodCallExpr whenBlock = this.whenThenDSL(desc, patternRelated, patternRelatedClass, WHEN_CALL, null);
        this.recurseAmongElseBranch(patternRelatedClass, patternRelated, whenBlock, desc.getElseBranch());
    }

    private void recurseAmongElseBranch(Class<?> patternType, PatternDescr patternRelated, MethodCallExpr parentMethodExpr, ConditionalBranchDescr branch) {
        if (branch != null) {
            MethodCallExpr elseWhenBlock = this.whenThenDSL(branch, patternRelated, patternType, ELSE_WHEN_CALL, parentMethodExpr);
            this.recurseAmongElseBranch(patternType, patternRelated, elseWhenBlock, branch.getElseBranch());
        } else {
            this.context.addExpression((Expression)parentMethodExpr);
        }
    }

    private MethodCallExpr whenThenDSL(ConditionalBranchDescr desc, PatternDescr patternRelated, Class<?> patternType, String callMethod, MethodCallExpr parentExpression) {
        MethodCallExpr when = new MethodCallExpr((Expression)parentExpression, callMethod);
        String condition = desc.getCondition().toString();
        if (!condition.equals("true")) {
            when.addArgument((Expression)new StringLiteralExpr(this.context.getConditionId(patternType, condition)));
            when.addArgument((Expression)new NameExpr(DrlxParseUtil.toVar(patternRelated.getIdentifier())));
            DrlxParseResult parseResult = ModelGenerator.drlxParse(this.context, this.packageModel, patternType, patternRelated.getIdentifier(), condition);
            when.addArgument(DrlxParseUtil.generateLambdaWithoutParameters(Collections.emptySortedSet(), parseResult.getExpr()));
        }
        MethodCallExpr then = new MethodCallExpr((Expression)when, THEN_CALL);
        MethodCallExpr rhs = this.onDSL(desc.getConsequence());
        then.addArgument((Expression)rhs);
        return then;
    }

    private BaseDescr getReferringPatternDescr(ConditionalBranchDescr desc, AndDescr parent) {
        BaseDescr b;
        BaseDescr patternRelated = null;
        Iterator iterator = parent.getDescrs().iterator();
        while (iterator.hasNext() && !(b = (BaseDescr)iterator.next()).equals(desc)) {
            patternRelated = b;
        }
        return patternRelated;
    }

    private MethodCallExpr onDSL(NamedConsequenceDescr namedConsequence) {
        String namedConsequenceString = this.context.getNamedConsequences().get(namedConsequence.getName());
        BlockStmt ruleVariablesBlock = new BlockStmt();
        ModelGenerator.createVariables(this.context.getKbuilder(), ruleVariablesBlock, this.packageModel, this.context);
        return ModelGenerator.createConsequenceCall(this.packageModel, null, this.context, namedConsequenceString, ruleVariablesBlock, namedConsequence.isBreaking());
    }
}

