/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.BaseKnowledgeBuilderResultImpl;
import org.drools.compiler.lang.descr.AnnotationDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.ruleunit.RuleUnitDescr;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.modelcompiler.builder.generator.DRLIdGenerator;
import org.drools.modelcompiler.builder.generator.DeclarationSpec;
import org.drools.modelcompiler.builder.generator.QueryParameter;
import org.kie.api.runtime.rule.RuleUnit;
import org.kie.internal.builder.KnowledgeBuilderResult;

public class RuleContext {
    private static final Map<Class<? extends RuleUnit>, RuleUnitDescr> ruleUnitDescrCache = new HashMap<Class<? extends RuleUnit>, RuleUnitDescr>();
    private final KnowledgeBuilderImpl kbuilder;
    private final InternalKnowledgePackage pkg;
    private DRLIdGenerator idGenerator;
    private final RuleDescr descr;
    private List<DeclarationSpec> declarations = new ArrayList<DeclarationSpec>();
    private List<DeclarationSpec> ooPathDeclarations = new ArrayList<DeclarationSpec>();
    private Deque<Consumer<Expression>> exprPointer = new LinkedList<Consumer<Expression>>();
    private List<Expression> expressions = new ArrayList<Expression>();
    private Map<String, String> namedConsequences = new HashMap<String, String>();
    private List<QueryParameter> queryParameters = new ArrayList<QueryParameter>();
    private Optional<String> queryName = Optional.empty();
    private RuleUnitDescr ruleUnitDescr;
    private RuleDialect ruleDialect = RuleDialect.JAVA;
    public BaseDescr parentDesc = null;

    public RuleContext(KnowledgeBuilderImpl kbuilder, InternalKnowledgePackage pkg, DRLIdGenerator exprIdGenerator, RuleDescr ruleDescr) {
        this.kbuilder = kbuilder;
        this.pkg = pkg;
        this.idGenerator = exprIdGenerator;
        this.descr = ruleDescr;
        this.exprPointer.push(this.expressions::add);
        this.findUnitClass();
    }

    private void findUnitClass() {
        if (this.descr == null) {
            return;
        }
        String unitName = null;
        AnnotationDescr unitAnn = this.descr.getAnnotation("Unit");
        if (unitAnn != null) {
            unitName = (String)unitAnn.getValue();
            unitName = unitName.substring(0, unitName.length() - ".class".length());
        } else if (this.descr.getUnit() != null) {
            unitName = this.descr.getUnit().getTarget();
        }
        if (unitName != null) {
            try {
                Class unitClass = this.pkg.getTypeResolver().resolveType(unitName);
                this.ruleUnitDescr = ruleUnitDescrCache.computeIfAbsent(unitClass, RuleUnitDescr::new);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public RuleUnitDescr getRuleUnitDescr() {
        return this.ruleUnitDescr;
    }

    public KnowledgeBuilderImpl getKbuilder() {
        return this.kbuilder;
    }

    public void addCompilationError(KnowledgeBuilderResult error) {
        if (error instanceof BaseKnowledgeBuilderResultImpl) {
            ((BaseKnowledgeBuilderResultImpl)error).setResource(this.descr.getResource());
        }
        this.kbuilder.addBuilderResult(error);
    }

    public Optional<DeclarationSpec> getDeclarationById(String id) {
        return this.declarations.stream().filter(d -> d.getBindingId().equals(id)).findFirst();
    }

    public boolean hasDeclaration(String id) {
        return this.getDeclarationById(id).isPresent();
    }

    public Collection<String> getAvailableBindings() {
        return this.declarations.stream().map(DeclarationSpec::getBindingId).collect(Collectors.toList());
    }

    public Optional<DeclarationSpec> getOOPathDeclarationById(String id) {
        return this.ooPathDeclarations.stream().filter(d -> d.getBindingId().equals(id)).findFirst();
    }

    public void addDeclaration(DeclarationSpec d) {
        if (!this.getDeclarationById(d.getBindingId()).isPresent()) {
            this.declarations.add(d);
        }
    }

    public void addOOPathDeclaration(DeclarationSpec d) {
        if (!this.getOOPathDeclarationById(d.getBindingId()).isPresent()) {
            this.ooPathDeclarations.add(d);
        }
    }

    public List<DeclarationSpec> getDeclarations() {
        return this.declarations;
    }

    public List<DeclarationSpec> getOOPathDeclarations() {
        return this.ooPathDeclarations;
    }

    public void addExpression(Expression e) {
        this.exprPointer.peek().accept(e);
    }

    public void pushExprPointer(Consumer<Expression> p) {
        this.exprPointer.push(p);
    }

    public Consumer<Expression> popExprPointer() {
        return this.exprPointer.pop();
    }

    public int getExprPointerLevel() {
        return this.exprPointer.size();
    }

    public InternalKnowledgePackage getPkg() {
        return this.pkg;
    }

    public String getExprId(Class<?> patternType, String drlConstraint) {
        return this.idGenerator.getExprId(patternType, drlConstraint);
    }

    public String getConditionId(Class<?> patternType, String drlConstraint) {
        return this.idGenerator.getCondId(patternType, drlConstraint);
    }

    public String getOOPathId(Class<?> patternType, String drlConstraint) {
        return this.idGenerator.getOOPathId(patternType, drlConstraint);
    }

    public String getOrCreateUnificationId(String drlConstraint) {
        return this.idGenerator.getOrCreateUnificationVariable(drlConstraint);
    }

    public Optional<String> getUnificationId(String drlConstraint) {
        return this.idGenerator.getUnificationVariable(drlConstraint);
    }

    public void addNamedConsequence(String key, String value) {
        this.namedConsequences.put(key, value);
    }

    public RuleDescr getRuleDescr() {
        return this.descr;
    }

    public RuleDialect getRuleDialect() {
        return this.ruleDialect;
    }

    public void setRuleDialect(RuleDialect ruleDialect) {
        this.ruleDialect = ruleDialect;
    }

    public Optional<QueryParameter> queryParameterWithName(Predicate<? super QueryParameter> predicate) {
        return this.queryParameters.stream().filter(predicate).findFirst();
    }

    public List<QueryParameter> getQueryParameters() {
        return this.queryParameters;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public Optional<String> getQueryName() {
        return this.queryName;
    }

    public void setQueryName(Optional<String> queryName) {
        this.queryName = queryName;
    }

    public Map<String, String> getNamedConsequences() {
        return this.namedConsequences;
    }

    public static enum RuleDialect {
        JAVA,
        MVEL;

    }
}

