/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.core.util.StringUtils;
import org.drools.javaparser.ast.body.ClassOrInterfaceDeclaration;
import org.drools.javaparser.printer.PrettyPrinter;
import org.drools.modelcompiler.builder.JavaParserCompiler;
import org.drools.modelcompiler.builder.PackageModel;

public class ModelWriter {
    private static final String RULES_FILE_NAME = "Rules";

    public Result writeModel(MemoryFileSystem srcMfs, Collection<PackageModel> packageModels) {
        ArrayList<String> sourceFiles = new ArrayList<String>();
        ArrayList<String> modelFiles = new ArrayList<String>();
        PrettyPrinter prettyPrinter = JavaParserCompiler.getPrettyPrinter();
        for (PackageModel pkgModel : packageModels) {
            String pkgName = pkgModel.getName();
            String folderName = pkgName.replace('.', '/');
            for (ClassOrInterfaceDeclaration generatedPojo : pkgModel.getGeneratedPOJOsSource()) {
                String source = JavaParserCompiler.toPojoSource(pkgModel.getName(), pkgModel.getImports(), generatedPojo);
                pkgModel.print(source);
                String pojoSourceName = "src/main/java/" + folderName + "/" + generatedPojo.getName() + ".java";
                srcMfs.write(pojoSourceName, source.getBytes());
                sourceFiles.add(pojoSourceName);
            }
            String rulesFileName = this.generateRulesFileName();
            String rulesSourceName = "src/main/java/" + folderName + "/" + rulesFileName + ".java";
            String rulesSource = pkgModel.getRulesSource(prettyPrinter, rulesFileName, pkgName);
            pkgModel.print(rulesSource);
            byte[] rulesBytes = rulesSource.getBytes();
            srcMfs.write(rulesSourceName, rulesBytes);
            modelFiles.add(pkgName + "." + rulesFileName);
            sourceFiles.add(rulesSourceName);
        }
        return new Result(sourceFiles, modelFiles);
    }

    private String generateRulesFileName() {
        return RULES_FILE_NAME + StringUtils.generateUUID();
    }

    public void writeModelFile(List<String> modelSources, MemoryFileSystem trgMfs) {
        String pkgNames = !modelSources.isEmpty() ? modelSources.stream().collect(Collectors.joining("\n")) : "\n";
        trgMfs.write("META-INF/kie/drools-model", pkgNames.getBytes());
    }

    public static class Result {
        final List<String> sourceFiles;
        final List<String> modelFiles;

        public Result(List<String> sourceFiles, List<String> modelFiles) {
            this.sourceFiles = sourceFiles;
            this.modelFiles = modelFiles;
        }

        public String[] getSources() {
            return this.sourceFiles.toArray(new String[this.sourceFiles.size()]);
        }
    }
}

