/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class StringUtil {
    private static final char[] HEX_ARRAY = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String toId(String id) {
        char[] cs;
        String fixStart = id;
        if (!Character.isJavaIdentifierStart(fixStart.charAt(0))) {
            fixStart = "_" + fixStart;
        }
        fixStart = fixStart.replaceAll("_", "__");
        StringBuilder result = new StringBuilder();
        for (char c : cs = fixStart.toCharArray()) {
            if (Character.isJavaIdentifierPart(c)) {
                result.append(c);
                continue;
            }
            result.append("_" + Integer.valueOf(c));
        }
        return result.toString();
    }

    public static String fileNameToClass(String fileName) {
        return fileName.substring(0, fileName.length() - ".class".length()).replace('/', '.');
    }

    public static String md5Hash(String s) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(s.getBytes());
            return StringUtil.bytesToHex(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }
}

