/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.operatorspec;

import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.UnaryExpr;
import java.util.Optional;
import org.drools.model.functions.Operator;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.TypedExpression;
import org.drools.modelcompiler.builder.generator.drlxparse.CoercedExpression;
import org.drools.modelcompiler.builder.generator.expressiontyper.ExpressionTyper;
import org.drools.modelcompiler.builder.generator.operatorspec.OperatorSpec;
import org.drools.mvel.parser.ast.expr.PointFreeExpr;

public class NativeOperatorSpec
implements OperatorSpec {
    public static final NativeOperatorSpec INSTANCE = new NativeOperatorSpec();

    @Override
    public Expression getExpression(RuleContext context, PointFreeExpr pointFreeExpr, TypedExpression left, ExpressionTyper expressionTyper) {
        MethodCallExpr methodCallExpr = new MethodCallExpr(null, "D.eval");
        String opName = pointFreeExpr.getOperator().asString();
        Operator operator = this.addOperatorArgument(context, methodCallExpr, opName);
        methodCallExpr.addArgument(left.getExpression());
        for (Expression rightExpr : pointFreeExpr.getRight()) {
            Optional<TypedExpression> optionalRight = expressionTyper.toTypedExpression(rightExpr).getTypedExpression();
            optionalRight.ifPresent(right -> {
                TypedExpression coercedRight;
                if (operator != null && operator.requiresCoercion()) {
                    CoercedExpression.CoercedExpressionResult coerce = new CoercedExpression(left, (TypedExpression)right).coerce();
                    coercedRight = coerce.getCoercedRight();
                } else {
                    coercedRight = right;
                }
                methodCallExpr.addArgument(coercedRight.getExpression());
            });
        }
        return pointFreeExpr.isNegated() ? new UnaryExpr((Expression)methodCallExpr, UnaryExpr.Operator.LOGICAL_COMPLEMENT) : methodCallExpr;
    }

    protected Operator addOperatorArgument(RuleContext context, MethodCallExpr methodCallExpr, String opName) {
        Operator operator = Operator.Register.getOperator((String)opName);
        try {
            operator.getClass().getField("INSTANCE");
            methodCallExpr.addArgument(operator.getClass().getCanonicalName() + ".INSTANCE");
        }
        catch (NoSuchFieldException e) {
            methodCallExpr.addArgument((Expression)new StringLiteralExpr(opName));
        }
        return operator;
    }

    @Override
    public boolean isStatic() {
        return false;
    }
}

