/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.util;

import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.ast.type.Type;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;

public class JavaParserUtil {
    public static Type toJavaParserType(Class<?> cls) {
        return JavaParserUtil.toJavaParserType(cls, cls.isPrimitive());
    }

    public static Type toJavaParserType(Class<?> cls, boolean primitive) {
        if (primitive) {
            if (cls == Integer.TYPE || cls == Integer.class) {
                return PrimitiveType.intType();
            }
            if (cls == Character.TYPE || cls == Character.class) {
                return PrimitiveType.intType();
            }
            if (cls == Long.TYPE || cls == Long.class) {
                return PrimitiveType.longType();
            }
            if (cls == Short.TYPE || cls == Short.class) {
                return PrimitiveType.shortType();
            }
            if (cls == Double.TYPE || cls == Double.class) {
                return PrimitiveType.doubleType();
            }
            if (cls == Float.TYPE || cls == Float.class) {
                return PrimitiveType.floatType();
            }
            if (cls == Boolean.TYPE || cls == Boolean.class) {
                return PrimitiveType.booleanType();
            }
            if (cls == Byte.TYPE || cls == Byte.class) {
                return PrimitiveType.byteType();
            }
        }
        return DrlxParseUtil.toClassOrInterfaceType(cls);
    }
}

