/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.query;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.ArrayCreationLevel;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.ArrayCreationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithParameters;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.TypeParameter;
import org.drools.modelcompiler.builder.generator.query.Generator;

public class QueryDefImplGenerator
extends Generator {
    private final int arity;
    private final String className;

    QueryDefImplGenerator(int arity) {
        super(arity);
        this.arity = arity;
        this.className = String.format("Query%dDefImpl", arity);
    }

    public String getClassName() {
        return this.className;
    }

    public CompilationUnit generate() {
        CompilationUnit cu = new CompilationUnit("org.drools.model.impl");
        cu.setImports(NodeList.nodeList((Node[])new ImportDeclaration[]{StaticJavaParser.parseImport((String)"import org.drools.model.Argument;"), StaticJavaParser.parseImport((String)String.format("import org.drools.model.Query%dDef;", this.arity)), StaticJavaParser.parseImport((String)"import org.drools.model.Variable;"), StaticJavaParser.parseImport((String)"import org.drools.model.view.QueryCallViewItem;"), StaticJavaParser.parseImport((String)"import org.drools.model.view.QueryCallViewItemImpl;"), StaticJavaParser.parseImport((String)"import static org.drools.model.FlowDSL.declarationOf;"), StaticJavaParser.parseImport((String)"import static org.drools.model.impl.RuleBuilder.DEFAULT_PACKAGE;")}));
        ClassOrInterfaceDeclaration clazz = this.classDeclaration(cu);
        this.nameClassConstructor(clazz);
        this.packageNameClassConstructor(clazz);
        this.nameClassArgConstructor(clazz);
        this.pkgNameClassArgConstructor(clazz);
        this.callMethod(clazz);
        this.getArgumentsMethod(clazz);
        this.getters(clazz);
        this.generateEquals(clazz);
        return cu;
    }

    private ClassOrInterfaceDeclaration classDeclaration(CompilationUnit cu) {
        ClassOrInterfaceDeclaration clazz = cu.addClass(this.className, new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        clazz.addExtendedType("QueryDefImpl");
        clazz.addImplementedType("ModelComponent");
        ClassOrInterfaceType implement = new ClassOrInterfaceType(null, String.format("Query%dDef", this.arity));
        NodeList typeArguments = NodeList.nodeList((Node[])new Type[0]);
        this.rangeArity().forEach(i -> {
            String genericTypeName = this.genericTypeName(i);
            typeArguments.add((Node)StaticJavaParser.parseType((String)genericTypeName));
            clazz.addTypeParameter(new TypeParameter(genericTypeName));
            clazz.addField(StaticJavaParser.parseType((String)this.genericType("Variable", genericTypeName)), this.argIndex(i), new Modifier.Keyword[]{Modifier.Keyword.PRIVATE, Modifier.Keyword.FINAL});
        });
        implement.setTypeArguments(typeArguments);
        clazz.addImplementedType(implement);
        return clazz;
    }

    private void nameClassConstructor(ClassOrInterfaceDeclaration clazz) {
        ConstructorDeclaration constructorDeclaration1 = clazz.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        this.addViewBuilderParameter((NodeWithParameters)constructorDeclaration1);
        this.addNameParameter((NodeWithParameters)constructorDeclaration1);
        BlockStmt statements = new BlockStmt();
        MethodCallExpr constructor = new MethodCallExpr(null, "this");
        statements.addStatement((Expression)constructor);
        this.addViewBuilderValue(constructor);
        this.addDefaultPackageValue(constructor);
        this.addNameValue(constructor);
        this.rangeArity().forEach(i -> {
            String genericTypeName = this.genericTypeName(i);
            String typeWithIndex = this.typeWithIndex(i);
            constructorDeclaration1.addParameter(this.classGenericParameter(genericTypeName), typeWithIndex);
            constructor.addArgument(typeWithIndex);
        });
        constructorDeclaration1.setBody(statements);
    }

    private void packageNameClassConstructor(ClassOrInterfaceDeclaration clazz) {
        ConstructorDeclaration declaration = clazz.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        this.addViewBuilderParameter((NodeWithParameters)declaration);
        this.addPackageParameter((NodeWithParameters)declaration);
        this.addNameParameter((NodeWithParameters)declaration);
        BlockStmt statements = new BlockStmt();
        MethodCallExpr body = new MethodCallExpr(null, "super");
        statements.addStatement((Expression)body);
        this.addViewBuilderValue(body);
        this.addPkgValue(body);
        this.addNameValue(body);
        this.rangeArity().forEach(i -> {
            String typeWithIndex = this.typeWithIndex(i);
            String genericTypeName = this.genericTypeName(i);
            declaration.addParameter(this.classGenericParameter(genericTypeName), typeWithIndex);
            AssignExpr assignExpr = new AssignExpr();
            assignExpr.setTarget((Expression)new FieldAccessExpr((Expression)new NameExpr("this"), this.argIndex(i)));
            assignExpr.setValue((Expression)new MethodCallExpr(null, "declarationOf", NodeList.nodeList((Node[])new Expression[]{new NameExpr(typeWithIndex)})));
            statements.addStatement((Expression)assignExpr);
        });
        declaration.setBody(statements);
    }

    private void nameClassArgConstructor(ClassOrInterfaceDeclaration clazz) {
        ConstructorDeclaration constructor = clazz.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        this.addViewBuilderParameter((NodeWithParameters)constructor);
        this.addNameParameter((NodeWithParameters)constructor);
        BlockStmt constructorStatements = new BlockStmt();
        MethodCallExpr constructorBody = new MethodCallExpr(null, "this");
        constructorStatements.addStatement((Expression)constructorBody);
        this.addViewBuilderValue(constructorBody);
        this.addDefaultPackageValue(constructorBody);
        this.addNameValue(constructorBody);
        this.rangeArity().forEach(i -> {
            String argWithIndex = this.argNameWithIndex(i);
            constructor.addParameter(this.classGenericName(i), this.typeWithIndex(i));
            constructor.addParameter("String", argWithIndex);
            constructorBody.addArgument(this.typeWithIndex(i));
            constructorBody.addArgument(argWithIndex);
        });
        constructor.setBody(constructorStatements);
    }

    private void pkgNameClassArgConstructor(ClassOrInterfaceDeclaration clazz) {
        ConstructorDeclaration constructorDeclaration2 = clazz.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        this.addViewBuilderParameter((NodeWithParameters)constructorDeclaration2);
        this.addPackageParameter((NodeWithParameters)constructorDeclaration2);
        this.addNameParameter((NodeWithParameters)constructorDeclaration2);
        BlockStmt statements = new BlockStmt();
        MethodCallExpr constructorBody = new MethodCallExpr(null, "super");
        statements.addStatement((Expression)constructorBody);
        this.addViewBuilderValue(constructorBody);
        this.addPkgValue(constructorBody);
        this.addNameValue(constructorBody);
        this.rangeArity().forEach(i -> {
            String argWithIndex = this.argNameWithIndex(i);
            constructorDeclaration2.addParameter(this.classGenericName(i), this.typeWithIndex(i));
            constructorDeclaration2.addParameter("String", argWithIndex);
            AssignExpr assignExpr = new AssignExpr();
            assignExpr.setTarget((Expression)new FieldAccessExpr((Expression)new NameExpr("this"), this.argIndex(i)));
            assignExpr.setValue((Expression)new MethodCallExpr(null, "declarationOf", NodeList.nodeList((Node[])new Expression[]{new NameExpr(this.typeWithIndex(i)), new NameExpr(argWithIndex)})));
            statements.addStatement((Expression)assignExpr);
        });
        constructorDeclaration2.setBody(statements);
    }

    private void callMethod(ClassOrInterfaceDeclaration clazz) {
        MethodDeclaration method = clazz.addMethod("call", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        this.addOverride(method);
        method.addParameter("boolean", "open");
        method.setType((Type)StaticJavaParser.parseClassOrInterfaceType((String)"QueryCallViewItem"));
        BlockStmt statements = new BlockStmt();
        NodeList arguments = NodeList.nodeList((Node[])new Expression[0]);
        ClassOrInterfaceType queryCallViewItemImpl = StaticJavaParser.parseClassOrInterfaceType((String)"QueryCallViewItemImpl");
        ObjectCreationExpr objCreationExpr = new ObjectCreationExpr(null, queryCallViewItemImpl, arguments);
        statements.addStatement((Statement)new ReturnStmt((Expression)objCreationExpr));
        objCreationExpr.addArgument("this");
        objCreationExpr.addArgument("open");
        this.rangeArity().forEach(i -> {
            String varWithIndex = this.stringWithIndex("var", i);
            String genericTypeName = this.genericTypeName(i);
            method.addParameter(this.genericType("Argument", genericTypeName), varWithIndex);
            objCreationExpr.addArgument(varWithIndex);
        });
        method.setBody(statements);
    }

    private void getArgumentsMethod(ClassOrInterfaceDeclaration clazz) {
        MethodDeclaration method = clazz.addMethod("getArguments", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        this.addOverride(method);
        Type variableArrayType = StaticJavaParser.parseType((String)"Variable<?>[]");
        method.setType(variableArrayType);
        BlockStmt statements = new BlockStmt();
        ArrayInitializerExpr arrayInitializerExpr = new ArrayInitializerExpr();
        ArrayCreationExpr arrayCreation = new ArrayCreationExpr(variableArrayType, NodeList.nodeList((Node[])new ArrayCreationLevel[0]), arrayInitializerExpr);
        statements.addStatement((Statement)new ReturnStmt((Expression)arrayCreation));
        NodeList values = NodeList.nodeList((Node[])new Expression[0]);
        this.rangeArity().forEach(i -> {
            String argIndex = this.argIndex(i);
            values.add((Node)new NameExpr(argIndex));
        });
        arrayInitializerExpr.setValues(values);
        method.setBody(statements);
    }

    private void getters(ClassOrInterfaceDeclaration clazz) {
        this.rangeArity().forEach(i -> {
            String genericTypeName = this.genericTypeName(i);
            String methodName = this.getArgIndex(i);
            String argWithIndex = this.argIndex(i);
            MethodDeclaration methodDeclaration = clazz.addMethod(methodName, new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
            this.addOverride(methodDeclaration);
            methodDeclaration.setType(this.genericType("Variable", genericTypeName));
            methodDeclaration.setBody(new BlockStmt(NodeList.nodeList((Node[])new Statement[]{new ReturnStmt((Expression)new NameExpr(argWithIndex))})));
        });
    }

    private void generateEquals(ClassOrInterfaceDeclaration clazz) {
        String template = "   @Override\n    public boolean isEqualTo( ModelComponent other ) {\n        if ( this == other ) return true;\n        if ( !(other instanceof DEF_IMPL_TYPE) ) return false;\n\n        DEF_IMPL_TYPE that = (DEF_IMPL_TYPE) other;\n\n        return EQUALS_CALL;\n    }";
        BodyDeclaration parse = StaticJavaParser.parseBodyDeclaration((String)template);
        BooleanLiteralExpr andExpr = new BooleanLiteralExpr(true);
        for (int i : this.rangeArity().toArray()) {
            String argWithIndex = this.argIndex(i);
            Expression e = StaticJavaParser.parseExpression((String)String.format("ModelComponent.areEqualInModel( %s, that.%s )", argWithIndex, argWithIndex));
            andExpr = new BinaryExpr((Expression)andExpr, e, BinaryExpr.Operator.AND);
        }
        BooleanLiteralExpr finalAndExpr = andExpr;
        parse.findAll(ClassOrInterfaceType.class, n -> n.toString().equals("DEF_IMPL_TYPE")).forEach(s -> s.replace((Node)StaticJavaParser.parseType((String)("Query" + this.arity + "DefImpl"))));
        parse.findAll(NameExpr.class, n -> n.toString().equals("EQUALS_CALL")).forEach(arg_0 -> QueryDefImplGenerator.lambda$generateEquals$11((Expression)finalAndExpr, arg_0));
        clazz.addMember(parse);
    }

    private static /* synthetic */ void lambda$generateEquals$11(Expression finalAndExpr, NameExpr s) {
        s.replace((Node)finalAndExpr);
    }
}

