/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator;

import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.type.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.drools.compiler.lang.descr.BehaviorDescr;
import org.drools.compiler.lang.descr.EntryPointDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.core.base.ClassObjectType;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.PatternExtractor;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;

public class DeclarationSpec {
    private final String bindingId;
    private final Class<?> declarationClass;
    private final Optional<PatternDescr> optPattern;
    private final Optional<Expression> declarationSource;
    private final Optional<String> variableName;
    private final Boolean isGlobal;

    public DeclarationSpec(String bindingId, Class<?> declarationClass) {
        this(bindingId, declarationClass, Optional.empty(), Optional.empty(), Optional.empty(), false);
    }

    public DeclarationSpec(String bindingId, Class<?> declarationClass, Boolean isGlobal) {
        this(bindingId, declarationClass, Optional.empty(), Optional.empty(), Optional.empty(), isGlobal);
    }

    DeclarationSpec(String bindingId, Class<?> declarationClass, String variableName) {
        this(bindingId, declarationClass, Optional.empty(), Optional.empty(), Optional.of(variableName), false);
    }

    DeclarationSpec(String bindingId, Class<?> declarationClass, Expression declarationSource) {
        this(bindingId, declarationClass, Optional.empty(), Optional.of(declarationSource), Optional.empty(), false);
    }

    DeclarationSpec(String bindingId, Class<?> declarationClass, Optional<PatternDescr> pattern, Optional<Expression> declarationSource, Optional<String> variableName, Boolean isGlobal) {
        this.bindingId = bindingId;
        this.declarationClass = declarationClass;
        this.optPattern = pattern;
        this.declarationSource = declarationSource;
        this.variableName = variableName;
        this.isGlobal = isGlobal;
    }

    Optional<String> getEntryPoint() {
        return this.optPattern.flatMap(pattern -> pattern.getSource() instanceof EntryPointDescr ? Optional.of(((EntryPointDescr)pattern.getSource()).getEntryId()) : Optional.empty());
    }

    public List<BehaviorDescr> getBehaviors() {
        return this.optPattern.map(PatternDescr::getBehaviors).orElse(Collections.emptyList());
    }

    public String getBindingId() {
        return this.bindingId;
    }

    public Class<?> getDeclarationClass() {
        return this.declarationClass;
    }

    public Optional<Expression> getDeclarationSource() {
        return this.declarationSource;
    }

    public Optional<String> getVariableName() {
        return this.variableName;
    }

    public Type getType() {
        return DrlxParseUtil.classToReferenceType(this.getDeclarationClass());
    }

    public Boolean isGlobal() {
        return this.isGlobal;
    }

    public String toString() {
        return "DeclarationSpec{bindingId='" + this.bindingId + '\'' + ", declarationClass=" + this.declarationClass + ", isGlobal=" + this.isGlobal + '}';
    }

    public Declaration asDeclaration() {
        Declaration decl = new Declaration(this.bindingId, (InternalReadAccessor)new PatternExtractor((ObjectType)new ClassObjectType(this.declarationClass)), null);
        decl.setDeclarationClass(this.declarationClass);
        return decl;
    }
}

