/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.visitor.pattern;

import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import java.util.List;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.generator.QueryGenerator;
import org.drools.modelcompiler.builder.generator.QueryParameter;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.visitor.DSLNode;

class Query
implements DSLNode {
    private final RuleContext context;
    private final PackageModel packageModel;
    private PatternDescr pattern;
    private List<? extends BaseDescr> constraintDescrs;
    private String queryName;

    public Query(RuleContext context, PackageModel packageModel, PatternDescr pattern, List<? extends BaseDescr> constraintDescrs, String queryName) {
        this.context = context;
        this.packageModel = packageModel;
        this.pattern = pattern;
        this.constraintDescrs = constraintDescrs;
        this.queryName = queryName;
    }

    @Override
    public void buildPattern() {
        NameExpr queryCall = new NameExpr(QueryGenerator.toQueryDef(this.pattern.getObjectType()));
        MethodCallExpr callCall = new MethodCallExpr((Expression)queryCall, "call");
        callCall.addArgument("" + !this.pattern.isQuery());
        if (!this.constraintDescrs.isEmpty()) {
            List<QueryParameter> queryParams = this.packageModel.queryVariables(this.queryName);
            Expression[] queryArgs = new Expression[queryParams.size()];
            block0: for (int i = 0; i < this.constraintDescrs.size(); ++i) {
                String itemText = this.constraintDescrs.get(i).getText();
                int colonPos = itemText.indexOf(58);
                if (colonPos > 0) {
                    String bindingId = itemText.substring(0, colonPos).trim();
                    String paramName = itemText.substring(colonPos + 1).trim();
                    for (int j = 0; j < queryParams.size(); ++j) {
                        if (queryParams.get(j).getName().equals(paramName)) {
                            this.addQueryArg(queryParams, queryArgs, bindingId, j);
                            continue block0;
                        }
                        if (!queryParams.get(j).getName().equals(bindingId)) continue;
                        this.addQueryArg(queryParams, queryArgs, paramName, j);
                        continue block0;
                    }
                    continue;
                }
                this.addQueryArg(queryParams, queryArgs, itemText, i);
            }
            for (Expression queryArg : queryArgs) {
                callCall.addArgument(queryArg);
            }
        }
        this.context.addExpression((Expression)callCall);
    }

    private void addQueryArg(List<QueryParameter> queryParams, Expression[] queryArgs, String itemText, int i) {
        if (QueryGenerator.isLiteral(itemText)) {
            MethodCallExpr valueOfMethod = new MethodCallExpr(null, "D.valueOf");
            valueOfMethod.addArgument((Expression)new NameExpr(itemText));
            queryArgs[i] = valueOfMethod;
        } else {
            this.context.addDeclaration(itemText, queryParams.get(i).getType());
            queryArgs[i] = this.context.getVarExpr(itemText);
        }
    }
}

