/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.printer.PrettyPrinter;
import com.github.javaparser.printer.PrettyPrinterConfiguration;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.commons.jci.compilers.CompilationResult;
import org.drools.compiler.commons.jci.compilers.EclipseJavaCompiler;
import org.drools.compiler.commons.jci.compilers.JavaCompiler;
import org.drools.compiler.commons.jci.compilers.JavaCompilerFactory;
import org.drools.compiler.commons.jci.readers.ResourceReader;
import org.drools.compiler.commons.jci.stores.ResourceStore;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.rule.builder.dialect.java.JavaDialectConfiguration;
import org.drools.core.util.ClassUtils;
import org.drools.modelcompiler.builder.GeneratedClassWithPackage;
import org.drools.modelcompiler.builder.errors.CompilationProblemErrorResult;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.jci.CompilationProblem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaParserCompiler {
    private static final Logger logger = LoggerFactory.getLogger(JavaParserCompiler.class);
    private static final JavaDialectConfiguration.CompilerType COMPILER_TYPE = ClassUtils.isJboss() ? JavaDialectConfiguration.CompilerType.ECLIPSE : JavaDialectConfiguration.CompilerType.NATIVE;
    private static final JavaCompiler JAVA_COMPILER = JavaParserCompiler.createCompiler();
    private static final PrettyPrinter PRETTY_PRINTER = JavaParserCompiler.createPrettyPrinter();

    private static JavaCompiler createCompiler() {
        JavaCompiler javaCompiler = JavaCompilerFactory.getInstance().loadCompiler(COMPILER_TYPE, "1.8");
        if (COMPILER_TYPE == JavaDialectConfiguration.CompilerType.ECLIPSE) {
            ((EclipseJavaCompiler)javaCompiler).setPrefix("src/main/java/");
        }
        return javaCompiler;
    }

    public static JavaCompiler getCompiler() {
        return JAVA_COMPILER;
    }

    private static PrettyPrinter createPrettyPrinter() {
        PrettyPrinterConfiguration config = new PrettyPrinterConfiguration();
        config.setColumnAlignParameters(true);
        config.setColumnAlignFirstMethodChain(true);
        return new PrettyPrinter(config);
    }

    public static PrettyPrinter getPrettyPrinter() {
        return PRETTY_PRINTER;
    }

    public static Map<String, Class<?>> compileAll(KnowledgeBuilderImpl kbuilder, ClassLoader classLoader, List<GeneratedClassWithPackage> classes) {
        if (classes == null || classes.isEmpty()) {
            return Collections.emptyMap();
        }
        MemoryFileSystem srcMfs = new MemoryFileSystem();
        MemoryFileSystem trgMfs = new MemoryFileSystem();
        String[] resources = JavaParserCompiler.writeModel(classes, srcMfs);
        CompilationResult resultCompilation = JavaParserCompiler.getCompiler().compile(resources, (ResourceReader)srcMfs, (ResourceStore)trgMfs, classLoader);
        CompilationProblem[] errors = resultCompilation.getErrors();
        if (errors.length != 0) {
            classes.forEach(c -> logger.error(c.toString()));
            for (CompilationProblem error : errors) {
                kbuilder.addBuilderResult((KnowledgeBuilderResult)new CompilationProblemErrorResult(error));
            }
            return Collections.emptyMap();
        }
        InternalClassLoader internalClassLoader = AccessController.doPrivileged(() -> new InternalClassLoader(classLoader, trgMfs));
        HashMap result = new HashMap();
        for (GeneratedClassWithPackage cls : classes) {
            String fullClassName = cls.getPackageName() + "." + cls.getGeneratedClass().getNameAsString();
            try {
                result.put(fullClassName, Class.forName(fullClassName, true, internalClassLoader));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private static String[] writeModel(List<GeneratedClassWithPackage> classes, MemoryFileSystem srcMfs) {
        ArrayList<String> sources = new ArrayList<String>();
        for (GeneratedClassWithPackage generatedPojo : classes) {
            String pkgName = generatedPojo.getPackageName();
            String folderName = pkgName.replace('.', '/');
            ClassOrInterfaceDeclaration generatedClass = generatedPojo.getGeneratedClass();
            String varsSourceName = String.format("src/main/java/%s/%s.java", folderName, generatedClass.getName());
            srcMfs.write(varsSourceName, JavaParserCompiler.toPojoSource(pkgName, generatedPojo.getImports(), generatedPojo.getStaticImports(), generatedClass).getBytes());
            sources.add(varsSourceName);
        }
        return sources.toArray(new String[sources.size()]);
    }

    public static String toPojoSource(String pkgName, Collection<String> imports, Collection<String> staticImports, ClassOrInterfaceDeclaration pojo) {
        CompilationUnit cu = new CompilationUnit();
        cu.setPackageDeclaration(pkgName);
        for (String i : imports) {
            cu.addImport(i);
        }
        for (String i : staticImports) {
            cu.addImport(i, true, false);
        }
        cu.addType((TypeDeclaration)pojo);
        return JavaParserCompiler.getPrettyPrinter().print((Node)cu);
    }

    static class InternalClassLoader
    extends ClassLoader {
        private final MemoryFileSystem mfs;

        public InternalClassLoader(ClassLoader parent, MemoryFileSystem mfs) {
            super(parent);
            this.mfs = mfs;
        }

        @Override
        public Class<?> loadClass(String className) throws ClassNotFoundException {
            try {
                return super.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                String fileName = className.replace('.', '/') + ".class";
                byte[] bytes = this.mfs.getBytes(fileName);
                if (bytes == null) {
                    throw new ClassNotFoundException(className);
                }
                return this.defineClass(className, bytes, 0, bytes.length);
            }
        }
    }
}

