/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.expressiontyper;

import java.util.ArrayList;
import java.util.List;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.drlx.expr.InlineCastExpr;
import org.drools.javaparser.ast.expr.ArrayAccessExpr;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.expr.FieldAccessExpr;
import org.drools.javaparser.ast.expr.MethodCallExpr;

public class FlattenScope {
    public static List<Node> flattenScope(Expression expressionWithScope) {
        ArrayList<Node> res = new ArrayList<Node>();
        if (expressionWithScope instanceof FieldAccessExpr) {
            FieldAccessExpr fieldAccessExpr = (FieldAccessExpr)expressionWithScope;
            res.addAll(FlattenScope.flattenScope(fieldAccessExpr.getScope()));
            res.add((Node)fieldAccessExpr.getName());
        } else if (expressionWithScope instanceof MethodCallExpr) {
            MethodCallExpr methodCallExpr = (MethodCallExpr)expressionWithScope;
            if (methodCallExpr.getScope().isPresent()) {
                res.addAll(FlattenScope.flattenScope((Expression)methodCallExpr.getScope().get()));
            }
            res.add((Node)methodCallExpr);
        } else if (expressionWithScope instanceof InlineCastExpr && ((InlineCastExpr)expressionWithScope).getExpression() instanceof FieldAccessExpr) {
            InlineCastExpr inlineCastExpr = (InlineCastExpr)expressionWithScope;
            Expression internalScope = ((FieldAccessExpr)inlineCastExpr.getExpression()).getScope();
            res.addAll(FlattenScope.flattenScope(internalScope));
            res.add((Node)expressionWithScope);
        } else if (expressionWithScope instanceof ArrayAccessExpr) {
            ArrayAccessExpr arrayAccessExpr = (ArrayAccessExpr)expressionWithScope;
            res.addAll(FlattenScope.flattenScope(arrayAccessExpr.getName()));
            res.add((Node)arrayAccessExpr);
        } else {
            res.add((Node)expressionWithScope);
        }
        return res;
    }
}

