/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.drools.compiler.lang.descr.FunctionDescr;
import org.drools.javaparser.JavaParser;
import org.drools.javaparser.ast.Modifier;
import org.drools.javaparser.ast.NodeList;
import org.drools.javaparser.ast.body.MethodDeclaration;
import org.drools.javaparser.ast.body.Parameter;
import org.drools.javaparser.ast.stmt.BlockStmt;
import org.drools.javaparser.ast.stmt.TryStmt;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;

public class FunctionGenerator {
    public static MethodDeclaration toFunction(FunctionDescr desc) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        List parameterTypes = desc.getParameterTypes();
        for (int i = 0; i < parameterTypes.size(); ++i) {
            String type = (String)parameterTypes.get(i);
            String name = (String)desc.getParameterNames().get(i);
            parameters.add(new Parameter(JavaParser.parseType((String)type), name));
        }
        EnumSet<Modifier> modifiers = EnumSet.of(Modifier.PUBLIC, Modifier.STATIC);
        MethodDeclaration methodDeclaration = new MethodDeclaration(modifiers, desc.getName(), JavaParser.parseType((String)desc.getReturnType()), NodeList.nodeList(parameters));
        BlockStmt block = DrlxParseUtil.parseBlock("try {} catch (Exception e) { throw new RuntimeException(e); }");
        TryStmt tryStmt = (TryStmt)block.getStatement(0);
        tryStmt.setTryBlock(DrlxParseUtil.parseBlock(desc.getBody()));
        methodDeclaration.setBody(block);
        return methodDeclaration;
    }
}

