/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.BaseKnowledgeBuilderResultImpl;
import org.drools.compiler.lang.descr.AnnotationDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.core.ruleunit.RuleUnitDescription;
import org.drools.core.ruleunit.RuleUnitDescriptionLoader;
import org.drools.core.util.Bag;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.expr.MethodCallExpr;
import org.drools.javaparser.ast.expr.NameExpr;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.errors.UnknownRuleUnitError;
import org.drools.modelcompiler.builder.generator.DRLIdGenerator;
import org.drools.modelcompiler.builder.generator.DeclarationSpec;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;
import org.drools.modelcompiler.builder.generator.QueryGenerator;
import org.drools.modelcompiler.builder.generator.QueryParameter;
import org.kie.api.definition.type.ClassReactive;
import org.kie.api.definition.type.PropertyReactive;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.builder.ResultSeverity;
import org.kie.internal.builder.conf.PropertySpecificOption;
import org.kie.soup.project.datamodel.commons.types.TypeResolver;

public class RuleContext {
    private final KnowledgeBuilderImpl kbuilder;
    private final PackageModel packageModel;
    private final TypeResolver typeResolver;
    private DRLIdGenerator idGenerator;
    private final RuleDescr descr;
    private final boolean generatePatternDSL;
    private List<DeclarationSpec> allDeclarations = new ArrayList<DeclarationSpec>();
    private Map<String, DeclarationSpec> scopedDeclarations = new LinkedHashMap<String, DeclarationSpec>();
    private List<DeclarationSpec> ooPathDeclarations = new ArrayList<DeclarationSpec>();
    private Deque<Consumer<Expression>> exprPointer = new LinkedList<Consumer<Expression>>();
    private List<Expression> expressions = new ArrayList<Expression>();
    private Map<String, String> namedConsequences = new HashMap<String, String>();
    private List<QueryParameter> queryParameters = new ArrayList<QueryParameter>();
    private Optional<String> queryName = Optional.empty();
    private RuleUnitDescription ruleUnitDescr;
    private Map<String, Class<?>> ruleUnitVars = new HashMap();
    private Map<String, String> aggregatePatternMap = new HashMap<String, String>();
    private Boolean isNestedInsideOr = false;
    private Bag<String> bindingOr = new Bag();
    private Set<String> unusableOrBinding = new HashSet<String>();
    private RuleDialect ruleDialect = RuleDialect.JAVA;
    private Scope currentScope = new Scope("");
    private Deque<Scope> scopesStack = new LinkedList<Scope>();
    private Map<String, String> definedVars = new HashMap<String, String>();
    public BaseDescr parentDesc = null;
    private static int scopeCounter = 1;

    public RuleContext(KnowledgeBuilderImpl kbuilder, PackageModel packageModel, RuleDescr ruleDescr, TypeResolver typeResolver, boolean generatePatternDSL) {
        this.kbuilder = kbuilder;
        this.packageModel = packageModel;
        this.idGenerator = packageModel.getExprIdGenerator();
        this.descr = ruleDescr;
        this.exprPointer.push(this.expressions::add);
        this.typeResolver = typeResolver;
        this.generatePatternDSL = generatePatternDSL;
        this.findUnitClass();
    }

    private void findUnitClass() {
        if (this.descr == null) {
            return;
        }
        boolean useNamingConvention = false;
        String unitName = null;
        AnnotationDescr unitAnn = this.descr.getAnnotation("Unit");
        if (unitAnn != null) {
            unitName = (String)unitAnn.getValue();
            unitName = unitName.substring(0, unitName.length() - ".class".length());
        } else if (this.descr.getUnit() != null) {
            unitName = this.descr.getUnit().getTarget();
        } else {
            if (this.descr.getResource() == null) {
                return;
            }
            String drlFile = this.descr.getResource().getSourcePath();
            if (drlFile != null) {
                unitName = drlFile.substring(0, drlFile.length() - ".drl".length()).replaceAll("/", ".");
                useNamingConvention = true;
            }
        }
        RuleUnitDescriptionLoader ruleUnitDescriptionLoader = this.kbuilder.getPackageRegistry(this.packageModel.getName()).getPackage().getRuleUnitDescriptionLoader();
        Optional ruDescr = ruleUnitDescriptionLoader.getDescription(unitName);
        if (ruDescr.isPresent()) {
            this.ruleUnitDescr = (RuleUnitDescription)ruDescr.get();
        } else if (!useNamingConvention) {
            this.addCompilationError((KnowledgeBuilderResult)new UnknownRuleUnitError(unitName));
        }
    }

    public boolean isPatternDSL() {
        return this.generatePatternDSL;
    }

    public RuleUnitDescription getRuleUnitDescr() {
        return this.ruleUnitDescr;
    }

    public KnowledgeBuilderImpl getKbuilder() {
        return this.kbuilder;
    }

    public void addCompilationError(KnowledgeBuilderResult error) {
        if (error instanceof BaseKnowledgeBuilderResultImpl) {
            ((BaseKnowledgeBuilderResultImpl)error).setResource(this.descr.getResource());
        }
        this.kbuilder.addBuilderResult(error);
    }

    public boolean hasErrors() {
        return this.kbuilder.hasResults(new ResultSeverity[]{ResultSeverity.ERROR});
    }

    public Optional<DeclarationSpec> getDeclarationById(String id) {
        Class<?> unitVarType;
        DeclarationSpec spec = this.scopedDeclarations.get(this.getDeclarationKey(id));
        if (spec == null && (unitVarType = this.ruleUnitVars.get(id)) != null) {
            spec = new DeclarationSpec(id, unitVarType);
        }
        return Optional.ofNullable(spec);
    }

    private String getDeclarationKey(String id) {
        String var = this.definedVars.get(id);
        return var != null ? var : id;
    }

    public void removeDeclarationById(String id) {
        this.scopedDeclarations.remove(this.getDeclarationKey(id));
    }

    public boolean hasDeclaration(String id) {
        return this.scopedDeclarations.get(this.getDeclarationKey(id)) != null;
    }

    public void addGlobalDeclarations(Map<String, Class<?>> globals) {
        for (Map.Entry<String, Class<?>> ks : globals.entrySet()) {
            this.definedVars.put(ks.getKey(), ks.getKey());
            this.addDeclaration(new DeclarationSpec(ks.getKey(), ks.getValue(), true));
        }
    }

    public Optional<DeclarationSpec> getOOPathDeclarationById(String id) {
        return this.ooPathDeclarations.stream().filter(d -> d.getBindingId().equals(id)).findFirst();
    }

    public void addRuleUnitVar(String name, Class<?> type) {
        this.ruleUnitVars.put(name, type);
    }

    public Class<?> getRuleUnitVarType(String name) {
        return this.ruleUnitVars.get(name);
    }

    public DeclarationSpec addDeclaration(String bindingId, Class<?> declarationClass) {
        return this.addDeclaration(new DeclarationSpec(this.defineVar(bindingId), declarationClass));
    }

    public DeclarationSpec addDeclaration(String bindingId, Class<?> declarationClass, Optional<PatternDescr> pattern, Optional<Expression> declarationSource) {
        return this.addDeclaration(new DeclarationSpec(this.defineVar(bindingId), declarationClass, pattern, declarationSource, Optional.empty(), false));
    }

    public DeclarationSpec addDeclaration(String bindingId, Class<?> declarationClass, String variableName) {
        return this.addDeclaration(new DeclarationSpec(this.defineVar(bindingId), declarationClass, variableName));
    }

    public DeclarationSpec addDeclaration(String bindingId, Class<?> declarationClass, Expression declarationSource) {
        return this.addDeclaration(new DeclarationSpec(this.defineVar(bindingId), declarationClass, declarationSource));
    }

    private String defineVar(String var) {
        String bindingId = this.currentScope.id + var;
        this.definedVars.put(var, bindingId);
        this.currentScope.vars.add(var);
        return bindingId;
    }

    public DeclarationSpec addDeclaration(DeclarationSpec d) {
        this.scopedDeclarations.putIfAbsent(d.getBindingId(), d);
        return d;
    }

    public void addDeclarationReplacing(DeclarationSpec d) {
        String bindingId = d.getBindingId();
        Optional<DeclarationSpec> declarationById = this.getDeclarationById(bindingId);
        if (declarationById.isPresent()) {
            if (d.getDeclarationClass().isAssignableFrom(declarationById.get().getDeclarationClass())) {
                return;
            }
            this.removeDeclarationById(bindingId);
        }
        this.scopedDeclarations.put(d.getBindingId(), d);
    }

    public void addOOPathDeclaration(DeclarationSpec d) {
        if (!this.getOOPathDeclarationById(d.getBindingId()).isPresent()) {
            this.ooPathDeclarations.add(d);
        }
    }

    public Collection<DeclarationSpec> getAllDeclarations() {
        if (this.allDeclarations.isEmpty()) {
            return this.scopedDeclarations.values();
        }
        ArrayList<DeclarationSpec> declrs = new ArrayList<DeclarationSpec>(this.scopedDeclarations.values());
        declrs.addAll(this.allDeclarations);
        return declrs;
    }

    public Collection<String> getAvailableBindings() {
        return this.scopedDeclarations.keySet();
    }

    public List<DeclarationSpec> getOOPathDeclarations() {
        return this.ooPathDeclarations;
    }

    public void addExpression(Expression e) {
        this.exprPointer.peek().accept(e);
    }

    public void pushExprPointer(Consumer<Expression> p) {
        this.exprPointer.push(p);
    }

    public Consumer<Expression> popExprPointer() {
        return this.exprPointer.pop();
    }

    public int getExprPointerLevel() {
        return this.exprPointer.size();
    }

    public String getExprId(Class<?> patternType, String drlConstraint) {
        return this.idGenerator.getExprId(patternType, drlConstraint);
    }

    public String getConditionId(Class<?> patternType, String drlConstraint) {
        return this.idGenerator.getCondId(patternType, drlConstraint);
    }

    public String getOOPathId(Class<?> patternType, String drlConstraint) {
        return this.idGenerator.getOOPathId(patternType, drlConstraint);
    }

    public String getOrCreateUnificationId(String drlConstraint) {
        return this.idGenerator.getOrCreateUnificationVariable(drlConstraint);
    }

    public Optional<String> getUnificationId(String drlConstraint) {
        return this.idGenerator.getUnificationVariable(drlConstraint);
    }

    public String getOrCreateAccumulatorBindingId(String drlConstraint) {
        return this.idGenerator.getOrCreateAccumulateBindingId(drlConstraint);
    }

    public void addNamedConsequence(String key, String value) {
        this.namedConsequences.put(key, value);
    }

    public RuleDescr getRuleDescr() {
        return this.descr;
    }

    public String getRuleName() {
        return this.descr.getName();
    }

    public RuleDialect getRuleDialect() {
        return this.ruleDialect;
    }

    public void setRuleDialect(RuleDialect ruleDialect) {
        this.ruleDialect = ruleDialect;
    }

    public Optional<QueryParameter> queryParameterWithName(Predicate<? super QueryParameter> predicate) {
        return this.queryParameters.stream().filter(predicate).findFirst();
    }

    public List<QueryParameter> getQueryParameters() {
        return this.queryParameters;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public Optional<String> getQueryName() {
        return this.queryName;
    }

    public void setQueryName(Optional<String> queryName) {
        this.queryName = queryName;
    }

    public boolean isQuery() {
        return this.queryName.isPresent();
    }

    public Map<String, String> getNamedConsequences() {
        return this.namedConsequences;
    }

    public Map<String, String> getAggregatePatternMap() {
        return this.aggregatePatternMap;
    }

    public PackageModel getPackageModel() {
        return this.packageModel;
    }

    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public boolean isPropertyReactive(Class<?> patternClass) {
        PropertySpecificOption propertySpecificOption = this.kbuilder.getBuilderConfiguration().getPropertySpecificOption();
        return propertySpecificOption.isPropSpecific(patternClass.getAnnotation(PropertyReactive.class) != null, patternClass.getAnnotation(ClassReactive.class) != null);
    }

    public Optional<Class<?>> getFunctionType(String name) {
        Method m = this.packageModel.getStaticMethod(name);
        if (m != null) {
            return Optional.of(m.getReturnType());
        }
        return this.packageModel.getFunctions().stream().filter(method -> method.getNameAsString().equals(name)).findFirst().flatMap(method -> this.resolveType(method.getType().asString()));
    }

    public Optional<Class<?>> resolveType(String name) {
        try {
            return Optional.of(this.typeResolver.resolveType(name));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    public Boolean isNestedInsideOr() {
        return this.isNestedInsideOr;
    }

    public void setNestedInsideOr(Boolean nestedInsideOr) {
        this.isNestedInsideOr = nestedInsideOr;
    }

    public Bag<String> getBindingOr() {
        return this.bindingOr;
    }

    public Set<String> getUnusableOrBinding() {
        return this.unusableOrBinding;
    }

    public Expression getVarExpr(String x) {
        if (!this.isQuery()) {
            new NameExpr(this.getVar(x));
        }
        Optional<QueryParameter> optQueryParameter = this.queryParameterWithName(p -> p.name.equals(x));
        return optQueryParameter.map(qp -> {
            String queryDef = this.getQueryName().orElseThrow(RuntimeException::new);
            int queryParameterIndex = this.getQueryParameters().indexOf(qp) + 1;
            return new MethodCallExpr((Expression)new NameExpr(queryDef), QueryGenerator.toQueryArg(queryParameterIndex));
        }).orElse((Expression)new NameExpr(this.getVar(x)));
    }

    public String getVar(String x) {
        String var = x.startsWith("sCoPe") ? x : this.definedVars.get(x);
        return DrlxParseUtil.toVar(var != null ? var : this.currentScope.id + x);
    }

    public void pushScope() {
        this.scopesStack.addLast(this.currentScope);
        this.currentScope = new Scope();
    }

    public void popScope() {
        this.currentScope.clear();
        this.currentScope = this.scopesStack.removeLast();
    }

    private class Scope {
        private final String id;
        private List<String> vars = new ArrayList<String>();

        private Scope() {
            this("sCoPe" + scopeCounter++ + "_");
        }

        private Scope(String id) {
            this.id = id;
        }

        private void clear() {
            this.vars.forEach(v -> {
                RuleContext.this.definedVars.remove(v);
                RuleContext.this.allDeclarations.add(RuleContext.this.scopedDeclarations.remove(this.id + v));
            });
        }
    }

    public static enum RuleDialect {
        JAVA,
        MVEL;

    }
}

