/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.drools.compiler.kie.builder.impl.KieBaseUpdateContext;
import org.drools.compiler.kie.builder.impl.KieBaseUpdater;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.rule.TypeDeclaration;
import org.drools.modelcompiler.CanonicalKieModule;
import org.drools.modelcompiler.CanonicalKiePackages;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.rule.Rule;
import org.kie.internal.builder.ChangeType;
import org.kie.internal.builder.ResourceChange;
import org.kie.internal.builder.ResourceChangeSet;

public class CanonicalKieBaseUpdater
extends KieBaseUpdater {
    public CanonicalKieBaseUpdater(KieBaseUpdateContext ctx) {
        super(ctx);
    }

    public void run() {
        List<Object> rulesToBeAdded;
        List<Object> rulesToBeRemoved;
        CanonicalKieModule oldKM = (CanonicalKieModule)this.ctx.currentKM;
        CanonicalKieModule newKM = (CanonicalKieModule)this.ctx.newKM;
        newKM.setModuleClassLoader(((CanonicalKieModule)this.ctx.currentKM).getModuleClassLoader());
        CanonicalKiePackages newPkgs = newKM.getKiePackages(this.ctx.newKieBaseModel);
        HashMap<String, AtomicInteger> globalsCounter = new HashMap<String, AtomicInteger>();
        if (this.ctx.modifyingUsedClass) {
            for (Class cls : this.ctx.modifiedClasses) {
                this.clearInstancesOfModifiedClass(cls);
            }
            for (InternalKnowledgePackage kpkg : this.ctx.kBase.getPackagesMap().values()) {
                ArrayList types = new ArrayList(kpkg.getTypeDeclarations().values());
                for (TypeDeclaration type : types) {
                    kpkg.removeTypeDeclaration(type.getTypeName());
                    kpkg.addTypeDeclaration(((InternalKnowledgePackage)newPkgs.getKiePackage(kpkg.getName())).getTypeDeclaration(type.getTypeName()));
                }
            }
            rulesToBeRemoved = this.getAllRulesInKieBase(oldKM, this.ctx.currentKieBaseModel);
            rulesToBeAdded = this.getAllRulesInKieBase(newKM, this.ctx.newKieBaseModel);
        } else {
            this.ctx.kBase.processAllTypesDeclaration(newPkgs.getKiePackages());
            rulesToBeRemoved = new ArrayList();
            rulesToBeAdded = new ArrayList();
            for (ResourceChangeSet changeSet : this.ctx.cs.getChanges().values()) {
                if (!CanonicalKieBaseUpdater.isPackageInKieBase((KieBaseModel)this.ctx.newKieBaseModel, changeSet.getResourceName())) continue;
                InternalKnowledgePackage kpkg = (InternalKnowledgePackage)newPkgs.getKiePackage(changeSet.getResourceName());
                InternalKnowledgePackage oldKpkg = this.ctx.kBase.getPackage(changeSet.getResourceName());
                if (oldKpkg == null) {
                    try {
                        oldKpkg = (InternalKnowledgePackage)this.ctx.kBase.addPackage((KiePackage)new KnowledgePackageImpl(changeSet.getResourceName())).get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (kpkg != null) {
                    for (Rule newRule : kpkg.getRules()) {
                        RuleImpl rule = oldKpkg.getRule(newRule.getName());
                        if (rule == null) continue;
                        rule.setLoadOrder(((RuleImpl)newRule).getLoadOrder());
                    }
                }
                block19: for (ResourceChange change : changeSet.getChanges()) {
                    String changedItemName = change.getName();
                    if (change.getChangeType() == ChangeType.UPDATED || change.getChangeType() == ChangeType.REMOVED) {
                        switch (change.getType()) {
                            case GLOBAL: {
                                oldKpkg.removeGlobal(changedItemName);
                                AtomicInteger globalCounter = (AtomicInteger)globalsCounter.get(changedItemName);
                                if (globalCounter != null && globalCounter.decrementAndGet() > 0) break;
                                this.ctx.kBase.removeGlobal(changedItemName);
                                break;
                            }
                            case RULE: {
                                RuleImpl removedRule = oldKpkg.getRule(changedItemName);
                                rulesToBeRemoved.add(removedRule);
                                oldKpkg.removeRule(removedRule);
                                break;
                            }
                            case DECLARATION: {
                                oldKpkg.removeTypeDeclaration(changedItemName);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Unsupported change type: " + change.getType() + "!");
                            }
                        }
                    }
                    if (change.getChangeType() != ChangeType.UPDATED && change.getChangeType() != ChangeType.ADDED) continue;
                    switch (change.getType()) {
                        case GLOBAL: {
                            try {
                                globalsCounter.computeIfAbsent(changedItemName, name -> this.ctx.kBase.getGlobals().get(name) == null ? new AtomicInteger(1) : new AtomicInteger(0)).incrementAndGet();
                                Class globalClass = kpkg.getTypeResolver().resolveType((String)kpkg.getGlobals().get(changedItemName));
                                oldKpkg.addGlobal(changedItemName, globalClass);
                                this.ctx.kBase.addGlobal(changedItemName, globalClass);
                                continue block19;
                            }
                            catch (ClassNotFoundException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        case RULE: {
                            RuleImpl addedRule = kpkg.getRule(changedItemName);
                            rulesToBeAdded.add(addedRule);
                            oldKpkg.addRule(addedRule);
                            continue block19;
                        }
                        case DECLARATION: {
                            TypeDeclaration addedType = kpkg.getTypeDeclaration(changedItemName);
                            oldKpkg.addTypeDeclaration(addedType);
                            continue block19;
                        }
                    }
                    throw new IllegalArgumentException("Unsupported change type: " + change.getType() + "!");
                }
            }
        }
        this.ctx.kBase.removeRules(rulesToBeRemoved);
        this.ctx.kBase.addRules(rulesToBeAdded);
        for (InternalWorkingMemory wm : this.ctx.kBase.getWorkingMemories()) {
            wm.notifyWaitOnRest();
        }
    }

    private List<RuleImpl> getAllRulesInKieBase(CanonicalKieModule kieModule, KieBaseModelImpl model) {
        ArrayList<RuleImpl> rules = new ArrayList<RuleImpl>();
        for (KiePackage kiePackage : kieModule.getKiePackages(model).getKiePackages()) {
            if (!CanonicalKieBaseUpdater.isPackageInKieBase((KieBaseModel)this.ctx.currentKieBaseModel, kiePackage.getName())) continue;
            for (Rule oldRule : kiePackage.getRules()) {
                rules.add((RuleImpl)oldRule);
            }
        }
        return rules;
    }

    private static boolean isPackageInKieBase(KieBaseModel kieBaseModel, String pkgName) {
        return kieBaseModel.getPackages().isEmpty() || KieBuilderImpl.isPackageInKieBase((KieBaseModel)kieBaseModel, (String)pkgName);
    }
}

