/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.constraints;

import java.util.ArrayList;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.spi.Tuple;
import org.drools.core.time.Interval;
import org.drools.model.Index;
import org.drools.model.SingleConstraint;

public class ConstraintEvaluator {
    protected final SingleConstraint constraint;
    private final Declaration[] declarations;
    private Declaration[] requiredDeclarations;
    private final Declaration patternDeclaration;
    private final Pattern pattern;

    public ConstraintEvaluator(Declaration[] declarations, SingleConstraint constraint) {
        this.constraint = constraint;
        this.pattern = null;
        this.declarations = declarations;
        this.requiredDeclarations = declarations;
        this.patternDeclaration = null;
    }

    public ConstraintEvaluator(Pattern pattern, SingleConstraint constraint) {
        this.constraint = constraint;
        this.pattern = pattern;
        this.declarations = new Declaration[]{pattern.getDeclaration()};
        this.patternDeclaration = this.findPatternDeclaration();
        this.requiredDeclarations = new Declaration[0];
    }

    public ConstraintEvaluator(Declaration[] declarations, Pattern pattern, SingleConstraint constraint) {
        this.constraint = constraint;
        this.declarations = declarations;
        this.pattern = pattern;
        this.patternDeclaration = this.findPatternAndRequiredDeclaration();
    }

    private Declaration findPatternDeclaration() {
        for (int i = 0; i < this.declarations.length; ++i) {
            if (!this.pattern.getDeclaration().getIdentifier().equals(this.declarations[i].getIdentifier())) continue;
            return this.declarations[i];
        }
        return null;
    }

    private Declaration findPatternAndRequiredDeclaration() {
        Declaration patternDeclaration = null;
        ArrayList<Declaration> requiredDeclarationsList = new ArrayList<Declaration>();
        for (int i = 0; i < this.declarations.length; ++i) {
            if (this.pattern.getDeclaration() != null && this.pattern.getDeclaration().getIdentifier().equals(this.declarations[i].getIdentifier())) {
                patternDeclaration = this.declarations[i];
                continue;
            }
            requiredDeclarationsList.add(this.declarations[i]);
        }
        this.requiredDeclarations = requiredDeclarationsList.toArray(new Declaration[requiredDeclarationsList.size()]);
        return patternDeclaration;
    }

    public boolean evaluate(InternalFactHandle handle, InternalWorkingMemory workingMemory) {
        try {
            return this.constraint.getPredicate().test(this.declarations.length == 1 ? this.getSingleArg(handle, workingMemory) : this.getAlphaInvocationArgs(handle, workingMemory));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object[] getSingleArg(InternalFactHandle handle, InternalWorkingMemory workingMemory) {
        Object[] objectArray;
        if (this.declarations[0].isInternalFact()) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.declarations[0].getValue(workingMemory, handle.getObject());
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = handle.getObject();
        }
        return objectArray;
    }

    public Object[] getAlphaInvocationArgs(InternalFactHandle handle, InternalWorkingMemory workingMemory) {
        Object[] params = new Object[this.declarations.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = this.getArgument(handle, workingMemory, this.declarations[i], null);
        }
        return params;
    }

    private Object getArgument(InternalFactHandle handle, InternalWorkingMemory workingMemory, Declaration declaration, Tuple tuple) {
        if (declaration == this.patternDeclaration) {
            return handle.getObject();
        }
        Object object = tuple != null && declaration.getPattern().getOffset() < tuple.size() ? tuple.getObject(declaration.getPattern().getOffset()) : handle.getObject();
        return declaration.getValue(workingMemory, object);
    }

    public boolean evaluate(InternalFactHandle handle, Tuple tuple, InternalWorkingMemory workingMemory) {
        try {
            return this.constraint.getPredicate().test(this.getBetaInvocationArgs(handle, tuple, workingMemory));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object[] getBetaInvocationArgs(InternalFactHandle handle, Tuple tuple, InternalWorkingMemory workingMemory) {
        Object[] params = new Object[this.declarations.length];
        for (int i = 0; i < this.declarations.length; ++i) {
            params[i] = this.getArgument(handle, workingMemory, this.declarations[i], tuple);
        }
        return params;
    }

    protected InternalFactHandle[] getBetaInvocationFactHandles(InternalFactHandle handle, Tuple tuple) {
        InternalFactHandle[] fhs = new InternalFactHandle[this.declarations.length];
        for (int i = 0; i < fhs.length; ++i) {
            fhs[i] = this.declarations[i] == this.patternDeclaration ? handle : tuple.get(this.declarations[i].getPattern().getOffset());
        }
        return fhs;
    }

    public Index getIndex() {
        return this.constraint.getIndex();
    }

    public String[] getReactiveProps() {
        return this.constraint.getReactiveProps();
    }

    public String toString() {
        return this.constraint.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ConstraintEvaluator otherEval = (ConstraintEvaluator)other;
        if (!this.getId().equals(otherEval.getId())) {
            return false;
        }
        if (this.declarations.length != otherEval.declarations.length) {
            return false;
        }
        for (int i = 0; i < this.declarations.length; ++i) {
            if (this.declarations[i].getExtractor().equals(otherEval.declarations[i].getExtractor())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String getId() {
        return this.constraint.getExprId();
    }

    public Declaration[] getRequiredDeclarations() {
        return this.requiredDeclarations;
    }

    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
        for (int i = 0; i < this.declarations.length; ++i) {
            if (!this.declarations[i].equals((Object)oldDecl)) continue;
            this.declarations[i] = newDecl;
            break;
        }
    }

    public ConstraintEvaluator clone() {
        return this.pattern == null ? new ConstraintEvaluator(this.getClonedDeclarations(), this.constraint) : new ConstraintEvaluator(this.getClonedDeclarations(), this.pattern, this.constraint);
    }

    protected Declaration[] getClonedDeclarations() {
        Declaration[] clonedDeclarations = new Declaration[this.declarations.length];
        for (int i = 0; i < this.declarations.length; ++i) {
            clonedDeclarations[i] = this.declarations[i].clone();
        }
        return clonedDeclarations;
    }

    protected Declaration[] getDeclarations() {
        return this.declarations;
    }

    protected Pattern getPattern() {
        return this.pattern;
    }

    public boolean isTemporal() {
        return false;
    }

    public Interval getInterval() {
        throw new UnsupportedOperationException();
    }
}

