/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.visitor.accumulate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.drools.compiler.lang.descr.AccumulateDescr;
import org.drools.compiler.lang.descr.AndDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.DescrVisitor;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.compiler.rule.builder.util.AccumulateUtil;
import org.drools.core.base.accumulators.CollectAccumulator;
import org.drools.core.base.accumulators.CollectListAccumulateFunction;
import org.drools.core.base.accumulators.CollectSetAccumulateFunction;
import org.drools.core.rule.Pattern;
import org.drools.javaparser.JavaParser;
import org.drools.javaparser.ast.CompilationUnit;
import org.drools.javaparser.ast.Modifier;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.NodeList;
import org.drools.javaparser.ast.body.ClassOrInterfaceDeclaration;
import org.drools.javaparser.ast.body.MethodDeclaration;
import org.drools.javaparser.ast.body.Parameter;
import org.drools.javaparser.ast.body.VariableDeclarator;
import org.drools.javaparser.ast.expr.AssignExpr;
import org.drools.javaparser.ast.expr.BinaryExpr;
import org.drools.javaparser.ast.expr.ClassExpr;
import org.drools.javaparser.ast.expr.EnclosedExpr;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.expr.FieldAccessExpr;
import org.drools.javaparser.ast.expr.LambdaExpr;
import org.drools.javaparser.ast.expr.LiteralExpr;
import org.drools.javaparser.ast.expr.MethodCallExpr;
import org.drools.javaparser.ast.expr.NameExpr;
import org.drools.javaparser.ast.expr.VariableDeclarationExpr;
import org.drools.javaparser.ast.nodeTypes.NodeWithSimpleName;
import org.drools.javaparser.ast.stmt.BlockStmt;
import org.drools.javaparser.ast.stmt.ExpressionStmt;
import org.drools.javaparser.ast.stmt.ReturnStmt;
import org.drools.javaparser.ast.stmt.Statement;
import org.drools.javaparser.ast.type.Type;
import org.drools.javaparser.ast.type.UnknownType;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.errors.InvalidExpressionErrorResult;
import org.drools.modelcompiler.builder.generator.DeclarationSpec;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.TypedExpression;
import org.drools.modelcompiler.builder.generator.drlxparse.ConstraintParser;
import org.drools.modelcompiler.builder.generator.drlxparse.DrlxParseFail;
import org.drools.modelcompiler.builder.generator.drlxparse.DrlxParseResult;
import org.drools.modelcompiler.builder.generator.drlxparse.DrlxParseSuccess;
import org.drools.modelcompiler.builder.generator.drlxparse.ParseResultVisitor;
import org.drools.modelcompiler.builder.generator.expression.AbstractExpressionBuilder;
import org.drools.modelcompiler.builder.generator.expressiontyper.ExpressionTyper;
import org.drools.modelcompiler.builder.generator.expressiontyper.TypedExpressionResult;
import org.drools.modelcompiler.builder.generator.visitor.ModelGeneratorVisitor;
import org.drools.modelcompiler.builder.generator.visitor.accumulate.LegacyAccumulate;
import org.drools.modelcompiler.util.StringUtil;
import org.kie.api.runtime.rule.AccumulateFunction;
import org.kie.internal.builder.KnowledgeBuilderResult;

public abstract class AccumulateVisitor {
    protected final RuleContext context;
    protected final PackageModel packageModel;
    protected final ModelGeneratorVisitor modelGeneratorVisitor;
    protected AbstractExpressionBuilder expressionBuilder;
    private static final String ACCUMULATE_INLINE_FUNCTION = "public class AccumulateInlineFunction implements org.kie.api.runtime.rule.AccumulateFunction<AccumulateInlineFunction.ContextData> {\n\n    public static class ContextData implements java.io.Serializable {\n        // context fields will go here.\n    }\n\n    public void readExternal(java.io.ObjectInput in) throws java.io.IOException, ClassNotFoundException {\n        // functions are stateless, so nothing to serialize\n    }\n\n    public void writeExternal(java.io.ObjectOutput out) throws java.io.IOException {\n        // functions are stateless, so nothing to serialize\n    }\n\n    public ContextData createContext() {\n        return new ContextData();\n    }\n\n    public void init(ContextData data) {\n    }\n\n    public void accumulate(ContextData data, Object $single) {\n    }\n\n    public void reverse(ContextData data, Object $single) {\n    }\n\n    public Object getResult(ContextData data) {\n    }\n\n    public boolean supportsReverse() {\n    }\n\n    public Class<?> getResultType() {\n    }\n}";

    public AccumulateVisitor(RuleContext context, ModelGeneratorVisitor modelGeneratorVisitor, PackageModel packageModel) {
        this.context = context;
        this.modelGeneratorVisitor = modelGeneratorVisitor;
        this.packageModel = packageModel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visit(AccumulateDescr descr, PatternDescr basePattern) {
        MethodCallExpr accumulateDSL = new MethodCallExpr(null, "D.accumulate");
        this.context.addExpression((Expression)accumulateDSL);
        MethodCallExpr accumulateExprs = new MethodCallExpr(null, "D.and");
        accumulateDSL.addArgument((Expression)accumulateExprs);
        this.context.pushExprPointer(arg_0 -> ((MethodCallExpr)accumulateExprs).addArgument(arg_0));
        HashSet<String> externalDeclrs = new HashSet<String>(this.context.getAvailableBindings());
        BaseDescr input = descr.getInputPattern() == null ? descr.getInput() : descr.getInputPattern();
        input.accept((DescrVisitor)this.modelGeneratorVisitor);
        if (accumulateExprs.getArguments().isEmpty()) {
            accumulateDSL.remove((Node)accumulateExprs);
        } else if (accumulateExprs.getArguments().size() == 1) {
            accumulateDSL.setArgument(0, (Expression)accumulateExprs.getArguments().get(0));
        }
        if (!descr.getFunctions().isEmpty()) {
            boolean inputPatternHasConstraints = input instanceof PatternDescr && !((PatternDescr)input).getConstraint().getDescrs().isEmpty();
            List<String> allBindings = descr.getFunctions().stream().map(f -> f.getBind()).filter(Objects::nonNull).collect(Collectors.toList());
            Optional<InvalidExpressionErrorResult> invalidExpressionErrorResult = DrlxParseUtil.validateDuplicateBindings(this.context.getRuleName(), allBindings);
            invalidExpressionErrorResult.ifPresent(this.context::addCompilationError);
            if (invalidExpressionErrorResult.isPresent()) {
                return;
            }
            for (AccumulateDescr.AccumulateFunctionCallDescr function : descr.getFunctions()) {
                Optional<NewBinding> optNewBinding = this.visit(this.context, function, accumulateDSL, basePattern, inputPatternHasConstraints);
                this.processNewBinding(optNewBinding);
            }
        } else {
            if (!descr.getFunctions().isEmpty() || descr.getInitCode() == null) throw new UnsupportedOperationException("Unknown type of Accumulate.");
            if (input instanceof PatternDescr) {
                this.visitAccInlineCustomCode(this.context, descr, accumulateDSL, basePattern, (PatternDescr)input, externalDeclrs);
            } else {
                if (!(input instanceof AndDescr)) throw new UnsupportedOperationException("I was expecting input to be of type PatternDescr. " + input);
                BlockStmt actionBlock = this.parseBlock(descr.getActionCode());
                List<String> allNamesInActionBlock = this.collectNamesInBlock(this.context, actionBlock);
                Optional<BaseDescr> bindingUsedInAccumulate = ((AndDescr)input).getDescrs().stream().filter(b -> allNamesInActionBlock.contains(((PatternDescr)b).getIdentifier())).findFirst();
                bindingUsedInAccumulate.ifPresent(b -> this.visitAccInlineCustomCode(this.context, descr, accumulateDSL, basePattern, (PatternDescr)b, externalDeclrs));
            }
        }
        this.context.popExprPointer();
        this.postVisit();
    }

    protected Optional<NewBinding> visit(final RuleContext context, final AccumulateDescr.AccumulateFunctionCallDescr function, MethodCallExpr accumulateDSL, final PatternDescr basePattern, boolean inputPatternHasConstraints) {
        context.pushExprPointer(arg_0 -> ((MethodCallExpr)accumulateDSL).addArgument(arg_0));
        final MethodCallExpr functionDSL = new MethodCallExpr(null, "D.accFunction");
        String bindingId = Optional.ofNullable(function.getBind()).orElse(basePattern.getIdentifier());
        Optional<NewBinding> newBinding = Optional.empty();
        if (function.getParams().length == 0) {
            Optional<AccumulateFunction> optAccumulateFunction = this.getAccumulateFunction(function, Object.class);
            if (!optAccumulateFunction.isPresent()) {
                this.addNonExistingFunctionError(context, function);
                return Optional.empty();
            }
            AccumulateFunction accumulateFunction = optAccumulateFunction.get();
            this.validateAccFunctionTypeAgainstPatternType(context, basePattern, accumulateFunction);
            functionDSL.addArgument((Expression)new ClassExpr(DrlxParseUtil.toType(accumulateFunction.getClass())));
            Class accumulateFunctionResultType = accumulateFunction.getResultType();
            context.addDeclarationReplacing(new DeclarationSpec(bindingId, accumulateFunctionResultType));
        } else {
            String accumulateFunctionParameterStr = function.getParams()[0];
            Expression accumulateFunctionParameter = DrlxParseUtil.parseExpression(accumulateFunctionParameterStr).getExpr();
            if (accumulateFunctionParameter instanceof BinaryExpr) {
                DrlxParseResult parseResult = new ConstraintParser(context, this.packageModel).drlxParse(Object.class, bindingId, accumulateFunctionParameterStr);
                newBinding = parseResult.acceptWithReturnValue(new ParseResultVisitor<Optional<NewBinding>>(){

                    @Override
                    public Optional<NewBinding> onSuccess(DrlxParseSuccess drlxParseResult) {
                        Class<?> exprRawClass = drlxParseResult.getExprRawClass();
                        Optional<AccumulateFunction> optAccumulateFunction = AccumulateVisitor.this.getAccumulateFunction(function, exprRawClass);
                        if (!optAccumulateFunction.isPresent()) {
                            AccumulateVisitor.this.addNonExistingFunctionError(context, function);
                            return Optional.empty();
                        }
                        AccumulateFunction accumulateFunction = optAccumulateFunction.get();
                        AccumulateVisitor.this.validateAccFunctionTypeAgainstPatternType(context, basePattern, accumulateFunction);
                        String bindExpressionVariable = context.getExprId(accumulateFunction.getResultType(), drlxParseResult.getLeft().toString());
                        drlxParseResult.setExprBinding(bindExpressionVariable);
                        context.addDeclarationReplacing(new DeclarationSpec(drlxParseResult.getPatternBinding(), exprRawClass));
                        functionDSL.addArgument((Expression)new ClassExpr(DrlxParseUtil.toType(accumulateFunction.getClass())));
                        MethodCallExpr newBindingFromBinary = AccumulateVisitor.this.buildBinding(bindExpressionVariable, drlxParseResult.getUsedDeclarations(), drlxParseResult.getExpr());
                        context.addDeclarationReplacing(new DeclarationSpec(bindExpressionVariable, exprRawClass));
                        functionDSL.addArgument(context.getVarExpr(bindExpressionVariable));
                        return Optional.of(new NewBinding(Optional.empty(), newBindingFromBinary));
                    }

                    @Override
                    public Optional<NewBinding> onFail(DrlxParseFail failure) {
                        return Optional.empty();
                    }
                });
            } else if (accumulateFunctionParameter instanceof MethodCallExpr) {
                DrlxParseUtil.RemoveRootNodeResult methodCallWithoutRootNode = DrlxParseUtil.removeRootNode(accumulateFunctionParameter);
                String rootNodeName = this.getRootNodeName(methodCallWithoutRootNode);
                TypedExpression typedExpression = this.parseMethodCallType(context, rootNodeName, methodCallWithoutRootNode.getWithoutRootNode());
                Class<?> methodCallExprType = typedExpression.getRawClass();
                Optional<AccumulateFunction> optAccumulateFunction = this.getAccumulateFunction(function, methodCallExprType);
                if (!optAccumulateFunction.isPresent()) {
                    this.addNonExistingFunctionError(context, function);
                    return Optional.empty();
                }
                AccumulateFunction accumulateFunction = optAccumulateFunction.get();
                this.validateAccFunctionTypeAgainstPatternType(context, basePattern, accumulateFunction);
                Class accumulateFunctionResultType = accumulateFunction.getResultType();
                functionDSL.addArgument((Expression)new ClassExpr(DrlxParseUtil.toType(accumulateFunction.getClass())));
                String bindExpressionVariable = context.getExprId(accumulateFunctionResultType, typedExpression.toString());
                DrlxParseResult drlxParseResult = new ConstraintParser(context, context.getPackageModel()).drlxParse(Object.class, rootNodeName, accumulateFunctionParameterStr);
                newBinding = drlxParseResult.acceptWithReturnValue(result -> {
                    result.setExprBinding(bindExpressionVariable);
                    MethodCallExpr binding = this.expressionBuilder.buildBinding(result);
                    context.addDeclarationReplacing(new DeclarationSpec(bindExpressionVariable, methodCallExprType));
                    functionDSL.addArgument(context.getVarExpr(bindExpressionVariable));
                    context.addDeclarationReplacing(new DeclarationSpec(bindingId, accumulateFunctionResultType));
                    return Optional.of(new NewBinding(Optional.of(result.getPatternBinding()), binding));
                });
            } else if (accumulateFunctionParameter instanceof NameExpr) {
                Class<?> declarationClass = context.getDeclarationById(accumulateFunctionParameter.toString()).orElseThrow(RuntimeException::new).getDeclarationClass();
                String nameExpr = ((NameExpr)accumulateFunctionParameter).getName().asString();
                Optional<AccumulateFunction> optAccumulateFunction = this.getAccumulateFunction(function, declarationClass);
                if (!optAccumulateFunction.isPresent()) {
                    this.addNonExistingFunctionError(context, function);
                    return Optional.empty();
                }
                AccumulateFunction accumulateFunction = optAccumulateFunction.get();
                this.validateAccFunctionTypeAgainstPatternType(context, basePattern, accumulateFunction);
                functionDSL.addArgument((Expression)new ClassExpr(DrlxParseUtil.toType(accumulateFunction.getClass())));
                functionDSL.addArgument(context.getVarExpr(nameExpr));
                this.addBindingAsDeclaration(context, bindingId, declarationClass, accumulateFunction);
            } else if (accumulateFunctionParameter instanceof LiteralExpr) {
                Class<?> declarationClass = DrlxParseUtil.getLiteralExpressionType((LiteralExpr)accumulateFunctionParameter);
                Optional<AccumulateFunction> optAccumulateFunction = this.getAccumulateFunction(function, declarationClass);
                if (!optAccumulateFunction.isPresent()) {
                    this.addNonExistingFunctionError(context, function);
                    return Optional.empty();
                }
                AccumulateFunction accumulateFunction = optAccumulateFunction.get();
                this.validateAccFunctionTypeAgainstPatternType(context, basePattern, accumulateFunction);
                functionDSL.addArgument((Expression)new ClassExpr(DrlxParseUtil.toType(accumulateFunction.getClass())));
                functionDSL.addArgument((Expression)new MethodCallExpr(null, "D.valueOf", NodeList.nodeList((Node[])new Expression[]{accumulateFunctionParameter})));
                this.addBindingAsDeclaration(context, bindingId, declarationClass, accumulateFunction);
            } else {
                context.addCompilationError((KnowledgeBuilderResult)new InvalidExpressionErrorResult("Invalid expression" + accumulateFunctionParameterStr));
                return Optional.empty();
            }
        }
        if (bindingId != null) {
            MethodCallExpr asDSL = new MethodCallExpr((Expression)functionDSL, "as");
            asDSL.addArgument(context.getVarExpr(bindingId));
            accumulateDSL.addArgument((Expression)asDSL);
        }
        context.popExprPointer();
        return newBinding;
    }

    private void validateAccFunctionTypeAgainstPatternType(RuleContext context, PatternDescr basePattern, AccumulateFunction accumulateFunction) {
        boolean checkCollect;
        String expectedResultTypeString = basePattern.getObjectType();
        Class<?> expectedResultType = DrlxParseUtil.getClassFromType(context.getTypeResolver(), (Type)DrlxParseUtil.toClassOrInterfaceType(expectedResultTypeString));
        Class actualResultType = accumulateFunction.getResultType();
        boolean isJavaDialect = context.getRuleDialect().equals((Object)RuleContext.RuleDialect.JAVA);
        boolean isQuery = context.isQuery();
        boolean isCollectFunction = this.isCollectFunction(accumulateFunction);
        boolean isInsideAccumulate = ((AccumulateDescr)basePattern.getSource()).getInput() instanceof AndDescr;
        boolean bl = checkCollect = !isCollectFunction || isInsideAccumulate;
        if (!isQuery && checkCollect && isJavaDialect && !Pattern.isCompatibleWithAccumulateReturnType(expectedResultType, (Class)actualResultType)) {
            context.addCompilationError((KnowledgeBuilderResult)new InvalidExpressionErrorResult(String.format("Pattern of type: '[ClassObjectType class=%s]' on rule '%s' is not compatible with type %s returned by accumulate function.", expectedResultType.getCanonicalName(), context.getRuleName(), actualResultType.getCanonicalName())));
        }
    }

    private boolean isCollectFunction(AccumulateFunction accumulateFunction) {
        return accumulateFunction instanceof CollectListAccumulateFunction || accumulateFunction instanceof CollectSetAccumulateFunction || accumulateFunction instanceof CollectAccumulator;
    }

    private void addNonExistingFunctionError(RuleContext context, AccumulateDescr.AccumulateFunctionCallDescr function) {
        context.addCompilationError((KnowledgeBuilderResult)new InvalidExpressionErrorResult(String.format("Unknown accumulate function: '%s' on rule '%s'.", function.getFunction(), context.getRuleDescr().getName())));
    }

    private void addBindingAsDeclaration(RuleContext context, String bindingId, Class<?> declarationClass, AccumulateFunction accumulateFunction) {
        if (bindingId != null) {
            Class<?> accumulateFunctionResultType = accumulateFunction.getResultType();
            if ((accumulateFunctionResultType == Comparable.class || accumulateFunctionResultType == Number.class) && (Comparable.class.isAssignableFrom(declarationClass) || declarationClass.isPrimitive())) {
                accumulateFunctionResultType = declarationClass;
            }
            context.addDeclarationReplacing(new DeclarationSpec(bindingId, accumulateFunctionResultType));
        }
    }

    protected Optional<AccumulateFunction> getAccumulateFunction(AccumulateDescr.AccumulateFunctionCallDescr function, Class<?> methodCallExprType) {
        String accumulateFunctionName = AccumulateUtil.getFunctionName(() -> methodCallExprType, (String)function.getFunction());
        Optional<AccumulateFunction> bundledAccumulateFunction = Optional.ofNullable(this.packageModel.getConfiguration().getAccumulateFunction(accumulateFunctionName));
        Optional<AccumulateFunction> importedAccumulateFunction = Optional.ofNullable(this.packageModel.getAccumulateFunctions().get(accumulateFunctionName));
        return bundledAccumulateFunction.map(Optional::of).orElse(importedAccumulateFunction);
    }

    protected String getRootNodeName(DrlxParseUtil.RemoveRootNodeResult methodCallWithoutRootNode) {
        Expression rootNode = methodCallWithoutRootNode.getRootNode().orElseThrow(UnsupportedOperationException::new);
        if (!(rootNode instanceof NameExpr)) {
            throw new RuntimeException("Root node of expression should be a declaration");
        }
        String rootNodeName = ((NameExpr)rootNode).getName().asString();
        return rootNodeName;
    }

    protected TypedExpression parseMethodCallType(RuleContext context, String variableName, Expression methodCallWithoutRoot) {
        Class clazz = context.getDeclarationById(variableName).map(DeclarationSpec::getDeclarationClass).orElseThrow(RuntimeException::new);
        return DrlxParseUtil.toMethodCallWithClassCheck(context, methodCallWithoutRoot, null, clazz, context.getTypeResolver());
    }

    protected Expression buildConstraintExpression(Expression expr, Collection<String> usedDeclarations) {
        LambdaExpr lambdaExpr = new LambdaExpr();
        lambdaExpr.setEnclosingParameters(true);
        usedDeclarations.stream().map(s -> new Parameter((Type)new UnknownType(), s)).forEach(arg_0 -> ((LambdaExpr)lambdaExpr).addParameter(arg_0));
        lambdaExpr.setBody((Statement)new ExpressionStmt(expr));
        return lambdaExpr;
    }

    protected void visitAccInlineCustomCode(RuleContext context2, AccumulateDescr descr, MethodCallExpr accumulateDSL, PatternDescr basePattern, PatternDescr inputDescr, Set<String> externalDeclrs) {
        MethodDeclaration supportsReverseMethod;
        this.context.pushExprPointer(arg_0 -> ((MethodCallExpr)accumulateDSL).addArgument(arg_0));
        String targetClassName = StringUtil.toId(context2.getRuleDescr().getName()) + "Accumulate" + descr.getLine();
        String code = ACCUMULATE_INLINE_FUNCTION.replaceAll("AccumulateInlineFunction", targetClassName);
        CompilationUnit templateCU = JavaParser.parse((String)code);
        ClassOrInterfaceDeclaration templateClass = (ClassOrInterfaceDeclaration)templateCU.getClassByName(targetClassName).orElseThrow(() -> new RuntimeException("Template did not contain expected type definition."));
        ClassOrInterfaceDeclaration templateContextClass = templateClass.getMembers().stream().filter(m -> m instanceof ClassOrInterfaceDeclaration && ((ClassOrInterfaceDeclaration)m).getNameAsString().equals("ContextData")).map(ClassOrInterfaceDeclaration.class::cast).findFirst().orElseThrow(() -> new RuntimeException("Template did not contain expected type definition."));
        ArrayList<String> contextFieldNames = new ArrayList<String>();
        MethodDeclaration initMethod = (MethodDeclaration)templateClass.getMethodsByName("init").get(0);
        BlockStmt initBlock = JavaParser.parseBlock((String)("{" + descr.getInitCode() + "}"));
        ArrayList<DeclarationSpec> accumulateDeclarations = new ArrayList<DeclarationSpec>();
        Set<String> usedExtDeclrs = this.parseInitBlock(context2, descr, basePattern, templateContextClass, contextFieldNames, initMethod, initBlock, accumulateDeclarations);
        boolean useLegacyAccumulate = false;
        Type singleAccumulateType = null;
        MethodDeclaration accumulateMethod = (MethodDeclaration)templateClass.getMethodsByName("accumulate").get(0);
        BlockStmt actionBlock = this.parseBlock(descr.getActionCode());
        List<String> allNamesInActionBlock = this.collectNamesInBlock(context2, actionBlock);
        if (allNamesInActionBlock.size() == 1) {
            String nameExpr = (String)allNamesInActionBlock.iterator().next();
            accumulateMethod.getParameter(1).setName(nameExpr);
            singleAccumulateType = context2.getDeclarationById(nameExpr).get().getType();
        } else {
            allNamesInActionBlock.removeIf(name -> !externalDeclrs.contains(name));
            usedExtDeclrs.addAll(allNamesInActionBlock);
            useLegacyAccumulate = true;
        }
        Optional<Object> optReverseMethod = Optional.empty();
        if (descr.getReverseCode() != null) {
            BlockStmt reverseBlock = this.parseBlock(descr.getReverseCode());
            List<String> allNamesInReverseBlock = this.collectNamesInBlock(context2, reverseBlock);
            if (allNamesInReverseBlock.size() == 1) {
                MethodDeclaration reverseMethod = (MethodDeclaration)templateClass.getMethodsByName("reverse").get(0);
                reverseMethod.getParameter(1).setName((String)allNamesInReverseBlock.iterator().next());
                optReverseMethod = Optional.of(reverseMethod);
            } else {
                allNamesInActionBlock.removeIf(name -> !externalDeclrs.contains(name));
                usedExtDeclrs.addAll(allNamesInActionBlock);
                useLegacyAccumulate = true;
            }
        }
        if (useLegacyAccumulate || !usedExtDeclrs.isEmpty()) {
            new LegacyAccumulate(this.context, descr, basePattern, usedExtDeclrs).build();
            return;
        }
        for (DeclarationSpec d : accumulateDeclarations) {
            context2.addDeclaration(d);
        }
        this.writeAccumulateMethod(contextFieldNames, singleAccumulateType, accumulateMethod, actionBlock);
        MethodDeclaration resultMethod = (MethodDeclaration)templateClass.getMethodsByName("getResult").get(0);
        Type returnExpressionType = JavaParser.parseType((String)"java.lang.Object");
        Expression returnExpression = JavaParser.parseExpression((String)descr.getResultCode());
        if (returnExpression instanceof NameExpr) {
            returnExpression = new EnclosedExpr(returnExpression);
        }
        DrlxParseUtil.rescopeNamesToNewScope((Expression)new NameExpr("data"), contextFieldNames, returnExpression);
        ((BlockStmt)resultMethod.getBody().get()).addStatement((Statement)new ReturnStmt(returnExpression));
        MethodDeclaration getResultTypeMethod = (MethodDeclaration)templateClass.getMethodsByName("getResultType").get(0);
        ((BlockStmt)getResultTypeMethod.getBody().get()).addStatement((Statement)new ReturnStmt((Expression)new ClassExpr(returnExpressionType)));
        if (optReverseMethod.isPresent()) {
            supportsReverseMethod = (MethodDeclaration)templateClass.getMethodsByName("supportsReverse").get(0);
            ((BlockStmt)supportsReverseMethod.getBody().get()).addStatement(JavaParser.parseStatement((String)"return true;"));
            BlockStmt reverseBlock = this.parseBlock(descr.getReverseCode());
            this.writeAccumulateMethod(contextFieldNames, singleAccumulateType, (MethodDeclaration)optReverseMethod.get(), reverseBlock);
        } else {
            supportsReverseMethod = (MethodDeclaration)templateClass.getMethodsByName("supportsReverse").get(0);
            ((BlockStmt)supportsReverseMethod.getBody().get()).addStatement(JavaParser.parseStatement((String)"return false;"));
            MethodDeclaration reverseMethod = (MethodDeclaration)templateClass.getMethodsByName("reverse").get(0);
            ((BlockStmt)reverseMethod.getBody().get()).addStatement(JavaParser.parseStatement((String)"throw new UnsupportedOperationException(\"This function does not support reverse.\");"));
        }
        this.packageModel.addGeneratedPOJO(templateClass);
        MethodCallExpr functionDSL = new MethodCallExpr(null, "D.accFunction");
        functionDSL.addArgument((Expression)new ClassExpr(JavaParser.parseType((String)targetClassName)));
        functionDSL.addArgument(this.context.getVarExpr(inputDescr.getIdentifier()));
        String bindingId = basePattern.getIdentifier();
        MethodCallExpr asDSL = new MethodCallExpr((Expression)functionDSL, "as");
        asDSL.addArgument(this.context.getVarExpr(bindingId));
        accumulateDSL.addArgument((Expression)asDSL);
        this.context.popExprPointer();
    }

    private Set<String> parseInitBlock(RuleContext context2, AccumulateDescr descr, PatternDescr basePattern, ClassOrInterfaceDeclaration templateContextClass, List<String> contextFieldNames, MethodDeclaration initMethod, BlockStmt initBlock, List<DeclarationSpec> accumulateDeclarations) {
        HashSet<String> externalDeclrs = new HashSet<String>();
        for (Statement stmt : initBlock.getStatements()) {
            String variableName;
            BlockStmt initMethodBody = (BlockStmt)initMethod.getBody().get();
            if (stmt instanceof ExpressionStmt && ((ExpressionStmt)stmt).getExpression() instanceof VariableDeclarationExpr) {
                VariableDeclarationExpr vdExpr = (VariableDeclarationExpr)((ExpressionStmt)stmt).getExpression();
                for (VariableDeclarator vd : vdExpr.getVariables()) {
                    variableName = vd.getNameAsString();
                    contextFieldNames.add(variableName);
                    templateContextClass.addField(vd.getType(), variableName, new Modifier[]{Modifier.PUBLIC});
                    this.createInitializer(variableName, vd.getInitializer()).ifPresent(statement -> {
                        initMethodBody.addStatement(statement);
                        statement.findAll(NameExpr.class).stream().map(n -> n.toString()).filter(context2::hasDeclaration).forEach(externalDeclrs::add);
                    });
                    accumulateDeclarations.add(new DeclarationSpec(variableName, DrlxParseUtil.getClassFromContext(context2.getTypeResolver(), vd.getType().asString())));
                }
                continue;
            }
            if (stmt.isExpressionStmt()) {
                AssignExpr assignExpr;
                String targetName;
                Expression statementExpression = stmt.asExpressionStmt().getExpression();
                if (!statementExpression.isAssignExpr() || contextFieldNames.contains(targetName = (assignExpr = statementExpression.asAssignExpr()).getTarget().asNameExpr().toString())) continue;
                contextFieldNames.add(targetName);
                variableName = assignExpr.getTarget().toString();
                Expression initCreationExpression = assignExpr.getValue();
                ExpressionTyper expressionTyper = new ExpressionTyper(context2, Object.class, "", false);
                TypedExpressionResult typedExpressionResult = expressionTyper.toTypedExpression(initCreationExpression);
                Type type = typedExpressionResult.getTypedExpression().map(t -> DrlxParseUtil.classToReferenceType(t.getRawClass())).orElseThrow(() -> new RuntimeException("Unknown type: " + initCreationExpression));
                templateContextClass.addField(type, variableName, new Modifier[]{Modifier.PUBLIC});
                Optional<Statement> initializer = this.createInitializer(variableName, Optional.of(initCreationExpression));
                initializer.ifPresent(arg_0 -> ((BlockStmt)initMethodBody).addStatement(arg_0));
                accumulateDeclarations.add(new DeclarationSpec(variableName, DrlxParseUtil.getClassFromContext(context2.getTypeResolver(), type.asString())));
                continue;
            }
            initMethodBody.addStatement(stmt);
        }
        return externalDeclrs;
    }

    private BlockStmt parseBlock(String block) {
        String withTerminator = block.endsWith(";") ? block : block + ";";
        return JavaParser.parseBlock((String)("{" + withTerminator + "}"));
    }

    private Optional<Statement> createInitializer(String variableName, Optional<Expression> optInitializer) {
        if (optInitializer.isPresent()) {
            Expression initializer = optInitializer.get();
            FieldAccessExpr target = new FieldAccessExpr((Expression)new NameExpr("data"), variableName);
            ExpressionStmt initStmt = new ExpressionStmt((Expression)new AssignExpr((Expression)target, initializer, AssignExpr.Operator.ASSIGN));
            return Optional.of(initStmt);
        }
        return Optional.empty();
    }

    void writeAccumulateMethod(List<String> contextFieldNames, Type singleAccumulateType, MethodDeclaration accumulateMethod, BlockStmt actionBlock) {
        for (Statement stmt : actionBlock.getStatements()) {
            ExpressionStmt convertedExpressionStatement = new ExpressionStmt();
            for (ExpressionStmt eStmt : stmt.findAll(ExpressionStmt.class)) {
                Expression expressionUntyped = eStmt.getExpression();
                String parameterName = accumulateMethod.getParameter(1).getNameAsString();
                ExpressionTyper expressionTyper = new ExpressionTyper(this.context, Object.class, "", false);
                TypedExpressionResult typedExpression = expressionTyper.toTypedExpression(expressionUntyped);
                Expression expression = typedExpression.getTypedExpression().get().getExpression();
                DrlxParseUtil.forceCastForName(parameterName, singleAccumulateType, expression);
                DrlxParseUtil.rescopeNamesToNewScope((Expression)new NameExpr("data"), contextFieldNames, expression);
                convertedExpressionStatement.setExpression(expression);
            }
            ((BlockStmt)accumulateMethod.getBody().get()).addStatement((Statement)convertedExpressionStatement);
        }
    }

    List<String> collectNamesInBlock(RuleContext context2, BlockStmt block) {
        return block.findAll(NameExpr.class, n -> context2.hasDeclaration(n.getNameAsString())).stream().map(NodeWithSimpleName::getNameAsString).distinct().collect(Collectors.toList());
    }

    protected abstract MethodCallExpr buildBinding(String var1, Collection<String> var2, Expression var3);

    protected abstract void processNewBinding(Optional<NewBinding> var1);

    protected abstract void postVisit();

    class NewBinding {
        Optional<String> patternBinding;
        MethodCallExpr bindExpression;

        public NewBinding(Optional<String> patternBinding, MethodCallExpr bindExpression) {
            this.patternBinding = patternBinding;
            this.bindExpression = bindExpression;
        }
    }
}

