/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder;

import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.model.Model;
import org.drools.modelcompiler.CanonicalKiePackages;
import org.drools.modelcompiler.KiePackagesBuilder;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.conf.KieBaseOption;

public class KieBaseBuilder {
    private final String kBaseName;
    private final KieBaseConfiguration conf;

    public KieBaseBuilder() {
        this(null, null);
    }

    public KieBaseBuilder(KieBaseConfiguration conf) {
        this(null, conf);
    }

    public KieBaseBuilder(KieBaseModelImpl kBaseModel, KieBaseConfiguration conf) {
        this.conf = conf;
        this.kBaseName = kBaseModel != null ? kBaseModel.getName() : "defaultkiebase";
    }

    public InternalKnowledgeBase createKieBase(CanonicalKiePackages kpkgs) {
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase((String)this.kBaseName, (KieBaseConfiguration)this.conf);
        kBase.addPackages(kpkgs.getKiePackages());
        return kBase;
    }

    public static InternalKnowledgeBase createKieBaseFromModel(Model model, KieBaseOption ... options) {
        KieBaseConfiguration kieBaseConf = KieServices.get().newKieBaseConfiguration();
        if (options == null || options.length == 0) {
            for (KieBaseOption option : options) {
                kieBaseConf.setOption(option);
            }
        }
        return KieBaseBuilder.createKieBaseFromModel(model, kieBaseConf);
    }

    public static InternalKnowledgeBase createKieBaseFromModel(Model model, KieBaseConfiguration kieBaseConf) {
        KiePackagesBuilder builder = new KiePackagesBuilder(kieBaseConf);
        builder.addModel(model);
        return new KieBaseBuilder(kieBaseConf).createKieBase(builder.build());
    }
}

