/*
 * Decompiled with CFR 0.152.
 */
package org.drools.impact.analysis.parser.impl;

import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.CharLiteralExpr;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.LiteralExpr;
import com.github.javaparser.ast.expr.LongLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import org.drools.impact.analysis.parser.impl.ImpactAnalysisRuleContext;
import org.drools.model.codegen.execmodel.generator.DrlxParseUtil;
import org.drools.model.codegen.execmodel.generator.RuleContext;
import org.drools.mvel.parser.ast.expr.BigDecimalLiteralExpr;
import org.drools.mvel.parser.ast.expr.BigIntegerLiteralExpr;
import org.drools.util.TypeResolver;

public class ParserUtil {
    public static Object literalToValue(LiteralExpr literalExpr) {
        if (literalExpr instanceof StringLiteralExpr) {
            return literalExpr.asStringLiteralExpr().asString();
        }
        if (literalExpr instanceof CharLiteralExpr) {
            return Character.valueOf(literalExpr.asCharLiteralExpr().asChar());
        }
        if (literalExpr instanceof IntegerLiteralExpr) {
            return literalExpr.asIntegerLiteralExpr().asInt();
        }
        if (literalExpr instanceof LongLiteralExpr) {
            return literalExpr.asLongLiteralExpr().asLong();
        }
        if (literalExpr instanceof DoubleLiteralExpr) {
            return literalExpr.asDoubleLiteralExpr().asDouble();
        }
        if (literalExpr instanceof BooleanLiteralExpr) {
            return literalExpr.asBooleanLiteralExpr().getValue();
        }
        if (literalExpr instanceof BigDecimalLiteralExpr) {
            return ((BigDecimalLiteralExpr)literalExpr).asBigDecimal();
        }
        if (literalExpr instanceof BigIntegerLiteralExpr) {
            return ((BigIntegerLiteralExpr)literalExpr).asBigInteger();
        }
        return null;
    }

    public static Object objectCreationExprToValue(ObjectCreationExpr objectCreationExpr, RuleContext context) {
        ClassOrInterfaceType type = objectCreationExpr.getType();
        Class clazz = DrlxParseUtil.getClassFromType((TypeResolver)context.getTypeResolver(), (Type)type);
        if (clazz.equals(BigDecimal.class)) {
            NodeList arguments = objectCreationExpr.getArguments();
            Optional<Object> opt = arguments.stream().findFirst().filter(StringLiteralExpr.class::isInstance).map(literalExpr -> literalExpr.asStringLiteralExpr().asString()).map(BigDecimal::new);
            return opt.orElse(null);
        }
        if (clazz.equals(BigInteger.class)) {
            NodeList arguments = objectCreationExpr.getArguments();
            Optional<Object> opt = arguments.stream().findFirst().filter(StringLiteralExpr.class::isInstance).map(literalExpr -> literalExpr.asStringLiteralExpr().asString()).map(BigInteger::new);
            return opt.orElse(null);
        }
        return null;
    }

    public static Class<?> literalType(LiteralExpr literalExpr) {
        if (literalExpr instanceof StringLiteralExpr) {
            return String.class;
        }
        if (literalExpr instanceof IntegerLiteralExpr) {
            return Integer.class;
        }
        if (literalExpr instanceof LongLiteralExpr) {
            return Long.class;
        }
        if (literalExpr instanceof DoubleLiteralExpr) {
            return Double.class;
        }
        if (literalExpr instanceof BooleanLiteralExpr) {
            return Boolean.class;
        }
        return null;
    }

    public static String getLiteralString(RuleContext context, Expression expr) {
        Object value = ParserUtil.getLiteralValue(context, expr);
        return value instanceof String ? (String)value : null;
    }

    public static Object getLiteralValue(RuleContext context, Expression expr) {
        if (expr.isLiteralExpr()) {
            return ParserUtil.literalToValue(expr.asLiteralExpr());
        }
        if (expr.isMethodCallExpr()) {
            MethodCallExpr mce = expr.asMethodCallExpr();
            Optional<SimpleName> optString = mce.getScope().filter(Expression::isNameExpr).map(Expression::asNameExpr).map(NameExpr::getName).filter(name -> name.asString().equals("java.lang.String"));
            if (optString.isPresent() && mce.getName().asString().equals("valueOf")) {
                return ParserUtil.getLiteralValue(context, mce.getArgument(0));
            }
        } else if (expr.isNameExpr()) {
            return ((ImpactAnalysisRuleContext)context).getBindVariableLiteralMap().get(expr.asNameExpr().getNameAsString());
        }
        return null;
    }

    public static boolean isLiteral(Class<?> clazz) {
        return clazz == String.class || clazz == Integer.class || clazz == Long.class || clazz == Double.class || clazz == Boolean.class;
    }

    public static Expression stripEnclosedAndCast(Expression expr) {
        if (expr.isEnclosedExpr()) {
            expr = expr.asEnclosedExpr().getInner();
        }
        if (expr.isCastExpr()) {
            expr = expr.asCastExpr().getExpression();
        }
        return expr;
    }
}

